/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core.encode;

import com.power4j.tile.crypto.core.encode.AbstractEncoder;
import com.power4j.tile.crypto.core.encode.BufferEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;

public class Base64Encoder
extends AbstractEncoder
implements BufferEncoder {
    private final boolean urlSafe;
    public static final Base64Encoder BASIC = new Base64Encoder(false);
    public static final Base64Encoder URL_SAFE;
    public static final Base64Encoder DEFAULT;

    @Override
    protected String doEncode(byte[] data, int offset, int length) {
        return new String(Base64.encodeBase64((byte[])Arrays.copyOfRange(data, offset, offset + length), (boolean)true, (boolean)this.urlSafe), StandardCharsets.US_ASCII);
    }

    @Override
    protected byte[] doDecode(String data) {
        return Base64.decodeBase64((String)data);
    }

    @Override
    public String algorithm() {
        return "base64";
    }

    @Generated
    public Base64Encoder(boolean urlSafe) {
        this.urlSafe = urlSafe;
    }

    static {
        DEFAULT = URL_SAFE = new Base64Encoder(true);
    }
}

