/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core.encode;

import com.power4j.tile.crypto.core.encode.AbstractEncoder;
import com.power4j.tile.crypto.core.encode.BufferEncodeException;
import com.power4j.tile.crypto.core.encode.BufferEncoder;
import lombok.Generated;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexEncoder
extends AbstractEncoder
implements BufferEncoder {
    private final boolean lowerCase;
    public static final HexEncoder LOWER = new HexEncoder(true);
    public static final HexEncoder UPPER = new HexEncoder(false);
    public static final HexEncoder DEFAULT = LOWER;

    @Override
    protected String doEncode(byte[] data, int offset, int length) {
        return Hex.encodeHexString((byte[])data, (boolean)this.lowerCase);
    }

    @Override
    protected byte[] doDecode(String data) {
        try {
            return Hex.decodeHex((String)data);
        }
        catch (DecoderException e) {
            throw new BufferEncodeException("Hex Decode error:" + e.getMessage(), e);
        }
    }

    @Override
    public String algorithm() {
        return "hex";
    }

    @Generated
    public HexEncoder(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }
}

