/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.core.encode;

import com.power4j.tile.crypto.core.encode.AbstractEncoder;
import com.power4j.tile.crypto.core.encode.BufferEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public class UnicodeEncoder
extends AbstractEncoder
implements BufferEncoder {
    private final Charset charset;
    public static final UnicodeEncoder UTF_8 = new UnicodeEncoder(StandardCharsets.UTF_8);
    public static final UnicodeEncoder UTF_16LE = new UnicodeEncoder(StandardCharsets.UTF_16LE);
    public static final UnicodeEncoder UTF_16BE = new UnicodeEncoder(StandardCharsets.UTF_16BE);
    public static final UnicodeEncoder US_ASCII = new UnicodeEncoder(StandardCharsets.US_ASCII);
    public static final UnicodeEncoder DEFAULT = UTF_8;

    @Override
    protected String doEncode(byte[] data, int offset, int length) {
        return new String(data, offset, length, this.charset);
    }

    @Override
    protected byte[] doDecode(String data) {
        return data.getBytes(this.charset);
    }

    @Override
    public String algorithm() {
        return "unicode/" + this.charset.name();
    }

    @Generated
    public UnicodeEncoder(Charset charset) {
        this.charset = charset;
    }
}

