/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.dynamic;

import com.power4j.tile.crypto.dynamic.KeyPool;
import com.power4j.tile.crypto.dynamic.Pools;
import com.power4j.tile.crypto.dynamic.SimpleDynamicDecrypt;
import com.power4j.tile.crypto.utils.Validate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public class DynamicDecryptBuilder {
    private final String algorithmName;
    private final String mode;
    private final String padding;
    private KeyPool keyPool;
    private KeyPool ivPool;
    private Function<byte[], byte[]> checksumCalculator;
    private Supplier<Long> paramterSupplier;

    public DynamicDecryptBuilder(String algorithmName, String mode, String padding) {
        this.algorithmName = algorithmName;
        this.mode = mode;
        this.padding = padding;
    }

    public static DynamicDecryptBuilder of(String algorithmName, String mode, String padding) {
        return new DynamicDecryptBuilder(algorithmName, mode, padding);
    }

    public static DynamicDecryptBuilder sm4(String mode, String padding) {
        return DynamicDecryptBuilder.of("SM4", mode, padding);
    }

    public static DynamicDecryptBuilder sm4Ecb() {
        return DynamicDecryptBuilder.sm4("ECB", "PKCS7Padding");
    }

    public static DynamicDecryptBuilder sm4Cbc() {
        return DynamicDecryptBuilder.sm4("CBC", "PKCS7Padding");
    }

    public static DynamicDecryptBuilder sm4Cfb() {
        return DynamicDecryptBuilder.sm4("CFB", "NoPadding");
    }

    public static DynamicDecryptBuilder sm4Ofb() {
        return DynamicDecryptBuilder.sm4("OFB", "NoPadding");
    }

    public DynamicDecryptBuilder keyPool(KeyPool pool) {
        this.keyPool = pool;
        return this;
    }

    public DynamicDecryptBuilder ivPool(KeyPool pool) {
        this.ivPool = pool;
        return this;
    }

    public DynamicDecryptBuilder checksumCalculator(Function<byte[], byte[]> checksumCalculator) {
        this.checksumCalculator = checksumCalculator;
        return this;
    }

    public DynamicDecryptBuilder parameterSupplier(Supplier<Long> supplier) {
        this.paramterSupplier = supplier;
        return this;
    }

    public SimpleDynamicDecrypt simple() {
        Validate.notEmpty(this.algorithmName, "algorithmName must not be empty");
        Validate.notEmpty(this.mode, "mode must not be empty");
        Validate.notEmpty(this.padding, "padding must not be empty");
        Validate.notNull(this.keyPool, "keyPool must not be null");
        Validate.notNull(this.checksumCalculator, "checksumCalculator must not be null");
        Supplier<Long> paramSupplier = this.paramterSupplier == null ? () -> 0L : this.paramterSupplier;
        return new SimpleDynamicDecrypt(this.algorithmName, this.mode, this.padding, this.keyPool, this.ivPool == null ? Pools.empty() : this.ivPool, this.checksumCalculator, paramSupplier);
    }

    protected static boolean isEmpty(@Nullable String val) {
        return val == null || val.isEmpty();
    }

    protected static boolean isEmpty(@Nullable byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }
}

