/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.dynamic;

import com.power4j.tile.crypto.dynamic.DecryptInfo;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class DynamicDecryptResult {
    private final DecryptInfo matched;
    private final List<DecryptInfo> tried;

    public static DynamicDecryptResult success(DecryptInfo matched, List<DecryptInfo> tried) {
        if (tried.isEmpty()) {
            throw new IllegalArgumentException("Empty tried list");
        }
        return new DynamicDecryptResult(matched, tried);
    }

    public static DynamicDecryptResult fail(List<DecryptInfo> tried) {
        return new DynamicDecryptResult(null, tried);
    }

    public Optional<DecryptInfo> getMatched() {
        return Optional.ofNullable(this.matched);
    }

    public DecryptInfo requiredMatched() {
        return this.getMatched().orElseThrow(() -> new IllegalStateException("No matched due to decryption failure"));
    }

    public boolean success() {
        return this.matched != null;
    }

    @Generated
    public DynamicDecryptResult(DecryptInfo matched, List<DecryptInfo> tried) {
        this.matched = matched;
        this.tried = tried;
    }

    @Generated
    public List<DecryptInfo> getTried() {
        return this.tried;
    }
}

