/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.dynamic;

import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.dynamic.DynamicKey;
import com.power4j.tile.crypto.dynamic.KeyPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public final class Pools {
    public static KeyPool fixed(byte[] key) {
        return new FixedPool(key);
    }

    public static KeyPool fixed(long id, byte[] key) {
        return new FixedPool(id, key);
    }

    public static KeyPool rotation(byte[] ... keys) {
        ArrayList<DynamicKey> list = new ArrayList<DynamicKey>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            list.add(new DynamicKey(Integer.toString(i), keys[i]));
        }
        return new RotationPool(list);
    }

    public static KeyPool rotation(Collection<DynamicKey> keys) {
        return new RotationPool(keys);
    }

    public static KeyPool empty() {
        return EmptyPool.INSTANCE;
    }

    @Generated
    private Pools() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class FixedPool
    implements KeyPool {
        public static final long ID = 0L;
        private final DynamicKey key;

        public FixedPool(byte[] key) {
            this(0L, key);
        }

        public FixedPool(long id, byte[] key) {
            this.key = new DynamicKey(Long.toString(id), key);
        }

        @Override
        public DynamicKey one(long param) {
            return this.key;
        }

        @Override
        public List<DynamicKey> some(long param) {
            return Collections.singletonList(this.key);
        }
    }

    static class RotationPool
    implements KeyPool {
        private final DynamicKey[] keys;
        private final AtomicLong index = new AtomicLong(0L);

        RotationPool(DynamicKey[] keys) {
            this.keys = keys;
        }

        RotationPool(Collection<DynamicKey> keys) {
            DynamicKey[] array = new DynamicKey[keys.size()];
            this.keys = keys.toArray(array);
        }

        @Override
        public DynamicKey one(long param) {
            int pos = (int)(this.index.getAndIncrement() % (long)this.keys.length);
            return this.keys[pos];
        }

        @Override
        public List<DynamicKey> some(long param) {
            return Arrays.asList(this.keys);
        }
    }

    static class EmptyPool
    implements KeyPool {
        static final EmptyPool INSTANCE = new EmptyPool();

        EmptyPool() {
        }

        @Override
        public DynamicKey one(long param) {
            throw new GeneralCryptoException("No key available");
        }

        @Override
        public List<DynamicKey> some(long param) {
            throw new GeneralCryptoException("No key available");
        }
    }
}

