/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.dynamic;

import com.power4j.tile.crypto.bc.BouncyCastleQuickCipher;
import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.QuickCipherBuilder;
import com.power4j.tile.crypto.core.Slice;
import com.power4j.tile.crypto.core.UncheckedCipher;
import com.power4j.tile.crypto.core.Verified;
import com.power4j.tile.crypto.dynamic.DecryptInfo;
import com.power4j.tile.crypto.dynamic.DynamicDecrypt;
import com.power4j.tile.crypto.dynamic.DynamicDecryptResult;
import com.power4j.tile.crypto.dynamic.DynamicKey;
import com.power4j.tile.crypto.dynamic.KeyPool;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class SimpleDynamicDecrypt
implements DynamicDecrypt {
    private final String algorithmName;
    private final String mode;
    private final String padding;
    private final KeyPool keyPool;
    private final KeyPool ivPool;
    private final Function<byte[], byte[]> checksumCalculator;
    private final Supplier<Long> paramterSupplier;

    @Override
    public DynamicDecryptResult decrypt(UncheckedCipher store) {
        long timestamp = this.paramterSupplier.get();
        List<DynamicKey> keyList = this.keyPool.some(timestamp);
        List<DynamicKey> ivList = this.ivPool.some(timestamp);
        if (keyList.isEmpty()) {
            throw new GeneralCryptoException("No key found");
        }
        ArrayList<DecryptInfo> tried = new ArrayList<DecryptInfo>(keyList.size() + ivList.size());
        for (DynamicKey key : keyList) {
            DecryptInfo result;
            if (ivList.isEmpty()) {
                result = this.tryOne(store, key, null);
                tried.add(result);
                if (!result.isMatched()) continue;
                return DynamicDecryptResult.success(result, tried);
            }
            for (DynamicKey iv : ivList) {
                result = this.tryOne(store, key, iv);
                tried.add(result);
                if (!result.isMatched()) continue;
                return DynamicDecryptResult.success(result, tried);
            }
        }
        return DynamicDecryptResult.fail(tried);
    }

    protected DecryptInfo tryOne(UncheckedCipher input, DynamicKey key, @Nullable DynamicKey iv) {
        try {
            BouncyCastleQuickCipher cipher = QuickCipherBuilder.algorithm(this.algorithmName).mode(this.mode).padding(this.padding).secretKey(key.getKey()).ivParameter(iv == null ? null : iv.getKey()).checksumCalculator(this.checksumCalculator).checksumVerifier((cipherBlob, bytes) -> cipherBlob.getChecksum().dataEquals(this.checksumCalculator.apply((byte[])bytes))).build();
            Verified<byte[]> verified = cipher.decrypt(input, false);
            return DecryptInfo.builder().matched(verified.isPass()).keyTag(key.getTag()).checksum(input.getChecksum()).data(Slice.wrap(verified.getData())).build();
        }
        catch (GeneralCryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralCryptoException(e.getMessage(), e);
        }
    }

    @Generated
    public SimpleDynamicDecrypt(String algorithmName, String mode, String padding, KeyPool keyPool, KeyPool ivPool, Function<byte[], byte[]> checksumCalculator, Supplier<Long> paramterSupplier) {
        this.algorithmName = algorithmName;
        this.mode = mode;
        this.padding = padding;
        this.keyPool = keyPool;
        this.ivPool = ivPool;
        this.checksumCalculator = checksumCalculator;
        this.paramterSupplier = paramterSupplier;
    }
}

