/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.dynamic;

import com.power4j.tile.crypto.dynamic.DynamicKey;
import com.power4j.tile.crypto.dynamic.KeyPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimeBasedPool
implements KeyPool {
    private final KeyGenerator generator;
    private final int windowSize;
    private final long intervalMills;
    private final int keySize;

    public static Builder ofSize(int keySize) {
        return new Builder(keySize);
    }

    TimeBasedPool(KeyGenerator generator, int keySize, int windowSize, long intervalMills) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("window size must > 0");
        }
        if (intervalMills <= 0L) {
            throw new IllegalArgumentException("interval must > 0");
        }
        this.generator = generator;
        this.keySize = keySize;
        this.windowSize = windowSize;
        this.intervalMills = intervalMills;
    }

    @Override
    public DynamicKey one(long param) {
        return this.atOffset(param, 0);
    }

    @Override
    public List<DynamicKey> some(long param) {
        ArrayList<DynamicKey> keys = new ArrayList<DynamicKey>(this.windowSize * 2 + 1);
        keys.add(this.atOffset(param, 0));
        for (int i = 1; i <= this.windowSize; ++i) {
            keys.add(this.atOffset(param, i));
            keys.add(this.atOffset(param, -i));
        }
        return keys;
    }

    protected DynamicKey atOffset(long timestamp, int offset) {
        long seed = (timestamp + (long)offset * this.intervalMills) / this.intervalMills;
        return new DynamicKey(timestamp + ":" + offset, this.generator.generate(seed, this.keySize));
    }

    public static class Builder {
        private final int keySize;
        private int windowSize;
        private long interval;
        private byte[] fillBytes;

        Builder(int keySize) {
            this.keySize = keySize;
        }

        public Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder intervalSeconds(long seconds) {
            this.interval = seconds * 1000L;
            return this;
        }

        public Builder interval(Duration interval) {
            this.interval = interval.toMillis();
            return this;
        }

        public Builder fillBytes(byte[] fillBytes) {
            this.fillBytes = fillBytes;
            return this;
        }

        public TimeBasedPool build() {
            return new TimeBasedPool(new KeyGenerator(this.fillBytes), this.keySize, this.windowSize, this.interval);
        }
    }

    static class KeyGenerator {
        private final byte[] padding;

        KeyGenerator(byte[] padding) {
            if (padding.length == 0) {
                throw new IllegalArgumentException("padding must not be null or empty");
            }
            this.padding = Arrays.copyOf(padding, padding.length);
        }

        public byte[] generate(long timestamp, int keySize) {
            byte[] base = KeyGenerator.longBe(timestamp);
            byte[] key = Arrays.copyOf(base, keySize);
            for (int fillAt = base.length; fillAt < keySize; ++fillAt) {
                key[fillAt] = this.padding[fillAt % this.padding.length];
            }
            return key;
        }

        static byte[] longBe(long value) {
            ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            buffer.putLong(0, value);
            return buffer.array();
        }
    }
}

