/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.utils;

import com.power4j.tile.crypto.bc.GlobalBouncyCastleProvider;
import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.UncheckedCipher;
import com.power4j.tile.crypto.utils.Sm3Util;
import java.security.NoSuchAlgorithmException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.springframework.lang.Nullable;

public final class CryptoUtil {
    public static final Function<byte[], byte[]> SM3_CHECKSUM_CALCULATOR = b -> Sm3Util.hash(b, null);
    public static final BiFunction<UncheckedCipher, byte[], Boolean> SM3_CHECKSUM_VERIFIER = (input, b) -> input.getChecksum().dataEquals(SM3_CHECKSUM_CALCULATOR.apply((byte[])b));
    public static final BiFunction<UncheckedCipher, byte[], Boolean> IGNORED_CHECKSUM_VERIFIER = (blob, bytes) -> true;
    public static final Function<byte[], byte[]> EMPTY_CHECKSUM_CALCULATOR = b -> new byte[0];

    public static Cipher createCipher(String transformation) {
        try {
            return Cipher.getInstance(transformation, GlobalBouncyCastleProvider.INSTANCE.getProvider());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new GeneralCryptoException(e);
        }
    }

    public static SecretKeySpec createKey(byte[] key, String algorithmName) {
        return new SecretKeySpec(key, algorithmName);
    }

    public static String transformation(String algorithmName, String mode, String padding) {
        return algorithmName + "/" + mode + "/" + padding;
    }

    public static byte[] decodeHex(String val, @Nullable String errorMsg) {
        try {
            return Hex.decodeHex((String)val);
        }
        catch (Exception e) {
            throw CryptoUtil.wrapGeneralCryptoException(errorMsg, e);
        }
    }

    public static byte[] decodeBase64(String val, @Nullable String errorMsg) {
        try {
            return Hex.decodeHex((String)val);
        }
        catch (Exception e) {
            throw CryptoUtil.wrapGeneralCryptoException(errorMsg, e);
        }
    }

    public static GeneralCryptoException wrapGeneralCryptoException(@Nullable String msg, Throwable cause) {
        if (cause instanceof GeneralCryptoException) {
            return (GeneralCryptoException)cause;
        }
        return msg == null ? new GeneralCryptoException(cause) : new GeneralCryptoException(msg, cause);
    }

    @Generated
    private CryptoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

