/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.utils;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jce.spec.ECParameterSpec;

public final class Sm2Util {
    public static final X9ECParameters X_9_EC_PARAM = GMNamedCurves.getByName((String)"sm2p256v1");
    public static final ECDomainParameters P256V1_DOMAIN_PARAM = new ECDomainParameters(X_9_EC_PARAM.getCurve(), X_9_EC_PARAM.getG(), X_9_EC_PARAM.getN());

    public static KeyPair genKeyPair() throws InvalidAlgorithmParameterException {
        KeyPairGeneratorSpi.EC spi = new KeyPairGeneratorSpi.EC();
        ECParameterSpec parameterSpec = new ECParameterSpec(X_9_EC_PARAM.getCurve(), X_9_EC_PARAM.getG(), X_9_EC_PARAM.getN());
        SecureRandom secureRandom = new SecureRandom();
        spi.initialize((AlgorithmParameterSpec)parameterSpec, secureRandom);
        return spi.generateKeyPair();
    }

    public static byte[] extractPublicKeyBlob(KeyPair keyPair, boolean compress) {
        BCECPublicKey key = (BCECPublicKey)keyPair.getPublic();
        return key.getQ().getEncoded(compress);
    }

    public static BigInteger extractPrivateKeyBlob(KeyPair keyPair) {
        return ((BCECPrivateKey)keyPair.getPrivate()).getD();
    }

    public static Pair<BigInteger, byte[]> extractKeyBlob(KeyPair keyPair, boolean compress) {
        return Pair.of((Object)Sm2Util.extractPrivateKeyBlob(keyPair), (Object)Sm2Util.extractPublicKeyBlob(keyPair, compress));
    }

    @Generated
    private Sm2Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

