/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.utils;

import com.power4j.tile.crypto.bc.GlobalBouncyCastleProvider;
import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.encode.HexEncoder;
import com.power4j.tile.crypto.wrapper.InputDecoder;
import com.power4j.tile.crypto.wrapper.OutputEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.lang.Nullable;

public final class Sm3Util {
    public static final int SM3_BYTES = 32;

    public static byte[] hash(byte[] input, @Nullable byte[] salt) {
        return Sm3Util.hash(input, 0, salt);
    }

    public static byte[] hash(byte[] input, int outputLen, @Nullable byte[] salt) {
        MessageDigest digest = Sm3Util.messageDigest("SM3");
        if (salt != null && salt.length > 0) {
            digest.update(salt);
        }
        digest.update(input);
        if (outputLen > 0) {
            return Arrays.copyOf(digest.digest(), outputLen);
        }
        return digest.digest();
    }

    public static <T, R> R hash(InputDecoder<T> decoder, OutputEncoder<R> encoder, T input, int outputLen, @Nullable T salt) throws GeneralCryptoException {
        byte[] data = Sm3Util.hash(decoder.decode(input), outputLen, salt == null ? null : decoder.decode(salt));
        return encoder.encode(data);
    }

    public static String hashHex(String input, int outputLen, @Nullable String salt) throws GeneralCryptoException {
        return Sm3Util.hash(HexEncoder.DEFAULT::decode, HexEncoder.DEFAULT::encode, input, outputLen, salt);
    }

    public static String hashHex(String input, @Nullable String salt) throws GeneralCryptoException {
        return Sm3Util.hashHex(input, 0, salt);
    }

    public static boolean verifyHead(byte[] data, byte[] hash, @Nullable byte[] salt) {
        byte[] ours = Sm3Util.hash(data, hash.length, salt);
        return Arrays.equals(hash, ours);
    }

    public static boolean verify(byte[] data, byte[] hash, @Nullable byte[] salt) {
        byte[] ours = Sm3Util.hash(data, 0, salt);
        return Arrays.equals(hash, ours);
    }

    public static boolean verifyHeadHex(String data, String hash, @Nullable String salt) throws GeneralCryptoException {
        byte[] dataBytes = HexEncoder.DEFAULT.decode(data);
        byte[] hashBytes = HexEncoder.DEFAULT.decode(hash);
        byte[] saltBytes = salt == null ? null : HexEncoder.DEFAULT.decode(salt);
        return Sm3Util.verifyHead(dataBytes, hashBytes, saltBytes);
    }

    public static boolean verifyHex(String data, String hash, @Nullable String salt) throws GeneralCryptoException {
        byte[] dataBytes = HexEncoder.DEFAULT.decode(data);
        byte[] hashBytes = HexEncoder.DEFAULT.decode(hash);
        byte[] saltBytes = salt == null ? null : HexEncoder.DEFAULT.decode(salt);
        return Sm3Util.verify(dataBytes, hashBytes, saltBytes);
    }

    static MessageDigest messageDigest(String algorithm) throws GeneralCryptoException {
        try {
            return MessageDigest.getInstance(algorithm, GlobalBouncyCastleProvider.INSTANCE.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralCryptoException(e.getMessage(), e);
        }
    }

    @Generated
    private Sm3Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

