/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.utils;

import com.power4j.tile.crypto.core.GeneralCryptoException;
import com.power4j.tile.crypto.core.QuickCipher;
import com.power4j.tile.crypto.core.QuickCipherBuilder;
import com.power4j.tile.crypto.utils.CryptoUtil;
import lombok.Generated;

public final class Sm4Util {
    public static final int BLOCK_SIZE = 16;

    public static QuickCipher useEcbWithPadding(byte[] key) throws GeneralCryptoException {
        return Sm4Util.builderWithVerifySupport("ECB", "PKCS7Padding").secretKey(key).build();
    }

    public static QuickCipher useCbcWithPadding(byte[] key, byte[] iv) throws GeneralCryptoException {
        if (iv.length != 16) {
            throw new IllegalArgumentException(String.format("Invalid IV length: %d, should be %d", iv.length, 16));
        }
        return Sm4Util.builderWithVerifySupport("CBC", "PKCS7Padding").secretKey(key).ivParameter(iv).build();
    }

    public static QuickCipher useCfb(byte[] key, byte[] iv) throws GeneralCryptoException {
        if (iv.length != 16) {
            throw new IllegalArgumentException(String.format("Invalid IV length: %d, should be %d", iv.length, 16));
        }
        return Sm4Util.builderWithVerifySupport("CFB", "NoPadding").secretKey(key).ivParameter(iv).build();
    }

    public static QuickCipher useOfb(byte[] key, byte[] iv) throws GeneralCryptoException {
        if (iv.length != 16) {
            throw new IllegalArgumentException(String.format("Invalid IV length: %d, should be %d", iv.length, 16));
        }
        return Sm4Util.builderWithVerifySupport("OFB", "NoPadding").secretKey(key).ivParameter(iv).build();
    }

    public static QuickCipher useEcbWithPadding(String hexKey) throws GeneralCryptoException {
        byte[] key = CryptoUtil.decodeHex(hexKey, null);
        return Sm4Util.useEcbWithPadding(key);
    }

    public static QuickCipher useCbcWithPadding(String hexKey, String hexIv) throws GeneralCryptoException {
        byte[] key = CryptoUtil.decodeHex(hexKey, null);
        byte[] iv = CryptoUtil.decodeHex(hexIv, null);
        return Sm4Util.useCbcWithPadding(key, iv);
    }

    public static QuickCipher useCfb(String hexKey, String hexIv) throws GeneralCryptoException {
        byte[] key = CryptoUtil.decodeHex(hexKey, null);
        byte[] iv = CryptoUtil.decodeHex(hexIv, null);
        return Sm4Util.useCfb(key, iv);
    }

    public static QuickCipher useOfb(String hexKey, String hexIv) throws GeneralCryptoException {
        byte[] key = CryptoUtil.decodeHex(hexKey, null);
        byte[] iv = CryptoUtil.decodeHex(hexIv, null);
        return Sm4Util.useOfb(key, iv);
    }

    public static QuickCipherBuilder builder(String mode, String padding) {
        return QuickCipherBuilder.algorithm("SM4").mode(mode).padding(padding);
    }

    public static QuickCipherBuilder builderWithVerifySupport(String mode, String padding) {
        return Sm4Util.builder(mode, padding).sm3ChecksumCalculator().sm3ChecksumVerifier();
    }

    @Generated
    private Sm4Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

