/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.wrapper;

import com.power4j.tile.crypto.core.encode.UnicodeEncoder;
import com.power4j.tile.crypto.wrapper.DecodeException;
import com.power4j.tile.crypto.wrapper.InputDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringDecoder
implements InputDecoder<String> {
    private final InputDecoderAdapter adapter;
    public static final StringDecoder DEFAULT = new StringDecoder(Charset.defaultCharset());
    public static final StringDecoder UTF_8 = new StringDecoder(StandardCharsets.UTF_8);
    public static final StringDecoder ISO_8859_1 = new StringDecoder(StandardCharsets.ISO_8859_1);

    public StringDecoder(Charset charset) {
        this.adapter = new InputDecoderAdapter(charset);
    }

    @Override
    public byte[] decode(String data) throws DecodeException {
        return this.adapter.decode(data);
    }

    static class InputDecoderAdapter
    implements InputDecoder<String> {
        private final UnicodeEncoder encoder;

        InputDecoderAdapter(Charset charset) {
            this.encoder = new UnicodeEncoder(charset);
        }

        @Override
        public byte[] decode(String data) throws DecodeException {
            try {
                return this.encoder.decode(data);
            }
            catch (Exception e) {
                throw new DecodeException(e.getMessage(), e);
            }
        }
    }
}

