/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.tile.crypto.wrapper;

import com.power4j.tile.crypto.core.encode.UnicodeEncoder;
import com.power4j.tile.crypto.wrapper.EncodeException;
import com.power4j.tile.crypto.wrapper.OutputEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringEncoder
implements OutputEncoder<String> {
    private final OutputEncoderAdapter adapter;
    public static final StringEncoder DEFAULT = new StringEncoder(Charset.defaultCharset());
    public static final StringEncoder UTF_8 = new StringEncoder(StandardCharsets.UTF_8);
    public static final StringEncoder ISO_8859_1 = new StringEncoder(StandardCharsets.ISO_8859_1);

    public StringEncoder(Charset charset) {
        this.adapter = new OutputEncoderAdapter(charset);
    }

    @Override
    public String encode(byte[] data) throws EncodeException {
        return this.adapter.encode(data);
    }

    static class OutputEncoderAdapter
    implements OutputEncoder<String> {
        private final UnicodeEncoder encoder;

        OutputEncoderAdapter(Charset charset) {
            this.encoder = new UnicodeEncoder(charset);
        }

        @Override
        public String encode(byte[] data) throws EncodeException {
            return this.encoder.encode(data);
        }
    }
}

