/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.AbstractLoadAction;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;

public abstract class AbstractLoadActionDeserializer<T extends AbstractLoadAction>
extends StdDeserializer<T> {
    protected AbstractLoadActionDeserializer(Class<T> vc) {
        super(vc);
    }

    protected abstract T createAction(ParsingContext var1);

    public T deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "type": {
                    String typeValue = parser.nextTextValue();
                    if (!"LOAD".equals(typeValue) && !"DANGLING_LINE".equals(typeValue)) {
                        throw JsonMappingException.from((JsonParser)parser, (String)"Expected types LOAD, DANGLING_LINE");
                    }
                    return true;
                }
                case "id": {
                    context.id = parser.nextTextValue();
                    return true;
                }
                case "loadId": 
                case "danglingLineId": {
                    context.elementId = parser.nextTextValue();
                    return true;
                }
                case "relativeValue": {
                    parser.nextToken();
                    context.relativeValue = parser.getValueAsBoolean();
                    return true;
                }
                case "activePowerValue": {
                    parser.nextToken();
                    context.activePowerValue = parser.getValueAsDouble();
                    return true;
                }
                case "reactivePowerValue": {
                    parser.nextToken();
                    context.reactivePowerValue = parser.getValueAsDouble();
                    return true;
                }
            }
            return false;
        });
        return this.createAction(context);
    }

    protected static class ParsingContext {
        String id;
        String elementId;
        Boolean relativeValue;
        Double activePowerValue;
        Double reactivePowerValue;

        protected ParsingContext() {
        }
    }
}

