/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.GeneratorAction;
import com.powsybl.action.GeneratorActionBuilder;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;

public class GeneratorActionDeserializer
extends StdDeserializer<GeneratorAction> {
    public GeneratorActionDeserializer() {
        super(GeneratorAction.class);
    }

    public GeneratorAction deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "type": {
                    if (!"GENERATOR".equals(parser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)parser, (String)"Expected type GENERATOR");
                    }
                    return true;
                }
                case "id": {
                    context.id = parser.nextTextValue();
                    return true;
                }
                case "generatorId": {
                    context.generatorId = parser.nextTextValue();
                    return true;
                }
                case "activePowerRelativeValue": {
                    parser.nextToken();
                    context.activePowerRelativeValue = parser.getValueAsBoolean();
                    return true;
                }
                case "activePowerValue": {
                    parser.nextToken();
                    context.activePowerValue = parser.getValueAsDouble();
                    return true;
                }
                case "voltageRegulatorOn": {
                    parser.nextToken();
                    context.voltageRegulatorOn = parser.getValueAsBoolean();
                    return true;
                }
                case "targetV": {
                    parser.nextToken();
                    context.targetV = parser.getValueAsDouble();
                    return true;
                }
                case "targetQ": {
                    parser.nextToken();
                    context.targetQ = parser.getValueAsDouble();
                    return true;
                }
            }
            return false;
        });
        GeneratorActionBuilder generatorActionBuilder = new GeneratorActionBuilder();
        generatorActionBuilder.withId(context.id).withGeneratorId(context.generatorId);
        if (context.activePowerRelativeValue != null) {
            generatorActionBuilder.withActivePowerRelativeValue(context.activePowerRelativeValue);
        }
        if (context.activePowerValue != null) {
            generatorActionBuilder.withActivePowerValue(context.activePowerValue);
        }
        if (context.voltageRegulatorOn != null) {
            generatorActionBuilder.withVoltageRegulatorOn(context.voltageRegulatorOn);
        }
        if (context.targetV != null) {
            generatorActionBuilder.withTargetV(context.targetV);
        }
        if (context.targetQ != null) {
            generatorActionBuilder.withTargetQ(context.targetQ);
        }
        return generatorActionBuilder.build();
    }

    private static class ParsingContext {
        String id;
        String generatorId;
        Boolean activePowerRelativeValue;
        Double activePowerValue;
        Boolean voltageRegulatorOn;
        Double targetV;
        Double targetQ;

        private ParsingContext() {
        }
    }
}

