/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.HvdcAction;
import com.powsybl.action.HvdcActionBuilder;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.HvdcLine;
import java.io.IOException;

public class HvdcActionDeserializer
extends StdDeserializer<HvdcAction> {
    public HvdcActionDeserializer() {
        super(HvdcAction.class);
    }

    public HvdcAction deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "type": {
                    if (!"HVDC".equals(jsonParser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)jsonParser, (String)"Expected type HVDC");
                    }
                    return true;
                }
                case "id": {
                    context.id = jsonParser.nextTextValue();
                    return true;
                }
                case "hvdcId": {
                    context.hvdcId = jsonParser.nextTextValue();
                    return true;
                }
                case "acEmulationEnabled": {
                    jsonParser.nextToken();
                    context.acEmulationEnabled = jsonParser.getValueAsBoolean();
                    return true;
                }
                case "activePowerSetpoint": {
                    jsonParser.nextToken();
                    context.activePowerSetpoint = jsonParser.getValueAsDouble();
                    return true;
                }
                case "converterMode": {
                    context.converterMode = HvdcLine.ConvertersMode.valueOf((String)jsonParser.nextTextValue());
                    return true;
                }
                case "droop": {
                    jsonParser.nextToken();
                    context.droop = jsonParser.getValueAsDouble();
                    return true;
                }
                case "p0": {
                    jsonParser.nextToken();
                    context.p0 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "relativeValue": {
                    jsonParser.nextToken();
                    context.relativeValue = jsonParser.getValueAsBoolean();
                    return true;
                }
            }
            return false;
        });
        return new HvdcActionBuilder().withId(context.id).withHvdcId(context.hvdcId).withAcEmulationEnabled(context.acEmulationEnabled).withActivePowerSetpoint(context.activePowerSetpoint).withConverterMode(context.converterMode).withDroop(context.droop).withP0(context.p0).withRelativeValue(context.relativeValue).build();
    }

    private static class ParsingContext {
        String id;
        String hvdcId;
        Boolean acEmulationEnabled;
        Double activePowerSetpoint;
        HvdcLine.ConvertersMode converterMode;
        Double droop;
        Double p0;
        Boolean relativeValue;

        private ParsingContext() {
        }
    }
}

