/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.Action;
import com.powsybl.action.MultipleActionsAction;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;
import java.util.List;

public class MultipleActionsActionDeserializer
extends StdDeserializer<MultipleActionsAction> {
    public MultipleActionsActionDeserializer() {
        super(MultipleActionsAction.class);
    }

    public MultipleActionsAction deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "type": {
                    if (!"MULTIPLE_ACTIONS".equals(jsonParser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)jsonParser, (String)"Expected type MULTIPLE_ACTIONS");
                    }
                    return true;
                }
                case "id": {
                    context.id = jsonParser.nextTextValue();
                    return true;
                }
                case "actions": {
                    jsonParser.nextToken();
                    context.actions = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)jsonParser, Action.class);
                    return true;
                }
            }
            return false;
        });
        return new MultipleActionsAction(context.id, context.actions);
    }

    private static class ParsingContext {
        String id;
        List<Action> actions;

        private ParsingContext() {
        }
    }
}

