/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.SwitchAction;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;

public class SwitchActionDeserializer
extends StdDeserializer<SwitchAction> {
    public SwitchActionDeserializer() {
        super(SwitchAction.class);
    }

    public SwitchAction deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "type": {
                    if (!"SWITCH".equals(parser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)parser, (String)"Expected type SWITCH");
                    }
                    return true;
                }
                case "id": {
                    context.id = parser.nextTextValue();
                    return true;
                }
                case "switchId": {
                    context.switchId = parser.nextTextValue();
                    return true;
                }
                case "open": {
                    parser.nextToken();
                    context.open = parser.getValueAsBoolean();
                    return true;
                }
            }
            return false;
        });
        if (context.open == null) {
            throw JsonMappingException.from((JsonParser)parser, (String)"for switch action open field can't be null");
        }
        return new SwitchAction(context.id, context.switchId, context.open);
    }

    private static class ParsingContext {
        String id;
        String switchId;
        Boolean open;

        private ParsingContext() {
        }
    }
}

