/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.ThreeSides;
import java.io.IOException;

public class TerminalsConnectionActionDeserializer
extends StdDeserializer<TerminalsConnectionAction> {
    public TerminalsConnectionActionDeserializer() {
        super(TerminalsConnectionAction.class);
    }

    public TerminalsConnectionAction deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "type": {
                    if (!"TERMINALS_CONNECTION".equals(jsonParser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)jsonParser, (String)"Expected type TERMINALS_CONNECTION");
                    }
                    return true;
                }
                case "id": {
                    context.id = jsonParser.nextTextValue();
                    return true;
                }
                case "elementId": {
                    context.elementId = jsonParser.nextTextValue();
                    return true;
                }
                case "side": {
                    jsonParser.nextToken();
                    context.side = ThreeSides.valueOf((String)jsonParser.getValueAsString());
                    return true;
                }
                case "open": {
                    jsonParser.nextToken();
                    context.open = jsonParser.getValueAsBoolean();
                    return true;
                }
            }
            return false;
        });
        if (context.open == null) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"for terminal connection action open field can't be null");
        }
        if (context.side == null) {
            return new TerminalsConnectionAction(context.id, context.elementId, context.open);
        }
        return new TerminalsConnectionAction(context.id, context.elementId, context.side, context.open);
    }

    private static class ParsingContext {
        String id;
        String elementId;
        ThreeSides side;
        Boolean open;

        private ParsingContext() {
        }
    }
}

