/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.SwitchAction;
import com.powsybl.action.SwitchActionBuilder;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;

public class SwitchActionBuilderDeserializer
extends StdDeserializer<SwitchActionBuilder> {
    public SwitchActionBuilderDeserializer() {
        super(SwitchAction.class);
    }

    public SwitchActionBuilder deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        SwitchActionBuilder builder = new SwitchActionBuilder();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "type": {
                    if (!"SWITCH".equals(parser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)parser, (String)"Expected type SWITCH");
                    }
                    return true;
                }
                case "id": {
                    builder.withId(parser.nextTextValue());
                    return true;
                }
                case "switchId": {
                    builder.withSwitchId(parser.nextTextValue());
                    return true;
                }
                case "open": {
                    parser.nextToken();
                    builder.withOpen(parser.getValueAsBoolean());
                    return true;
                }
            }
            return false;
        });
        return builder;
    }
}

