/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.GeneratorActionBuilder;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;

public class GeneratorActionBuilderDeserializer
extends StdDeserializer<GeneratorActionBuilder> {
    public GeneratorActionBuilderDeserializer() {
        super(GeneratorActionBuilder.class);
    }

    public GeneratorActionBuilder deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        GeneratorActionBuilder generatorActionBuilder = new GeneratorActionBuilder();
        JsonUtil.parsePolymorphicObject((JsonParser)parser, name -> {
            switch (name) {
                case "type": {
                    if (!"GENERATOR".equals(parser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)parser, (String)"Expected type GENERATOR");
                    }
                    return true;
                }
                case "id": {
                    generatorActionBuilder.withId(parser.nextTextValue());
                    return true;
                }
                case "generatorId": {
                    generatorActionBuilder.withGeneratorId(parser.nextTextValue());
                    return true;
                }
                case "activePowerRelativeValue": {
                    parser.nextToken();
                    generatorActionBuilder.withActivePowerRelativeValue(parser.getValueAsBoolean());
                    return true;
                }
                case "activePowerValue": {
                    parser.nextToken();
                    generatorActionBuilder.withActivePowerValue(parser.getValueAsDouble());
                    return true;
                }
                case "voltageRegulatorOn": {
                    parser.nextToken();
                    generatorActionBuilder.withVoltageRegulatorOn(parser.getValueAsBoolean());
                    return true;
                }
                case "targetV": {
                    parser.nextToken();
                    generatorActionBuilder.withTargetV(parser.getValueAsDouble());
                    return true;
                }
                case "targetQ": {
                    parser.nextToken();
                    generatorActionBuilder.withTargetQ(parser.getValueAsDouble());
                    return true;
                }
            }
            return false;
        });
        return generatorActionBuilder;
    }
}

