/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractLoadAction;
import com.powsybl.iidm.modification.LoadModification;
import com.powsybl.iidm.modification.NetworkModification;
import java.util.Objects;

public class LoadAction
extends AbstractLoadAction {
    public static final String NAME = "LOAD";
    private final String loadId;

    LoadAction(String id, String loadId, boolean relativeValue, Double activePowerValue, Double reactivePowerValue) {
        super(id, relativeValue, activePowerValue, reactivePowerValue);
        this.loadId = Objects.requireNonNull(loadId);
    }

    public String getLoadId() {
        return this.loadId;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public NetworkModification toModification() {
        return new LoadModification(this.getLoadId(), this.isRelativeValue(), (Double)this.getActivePowerValue().stream().boxed().findFirst().orElse(null), (Double)this.getReactivePowerValue().stream().boxed().findFirst().orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadAction that = (LoadAction)o;
        return Objects.equals(this.loadId, that.loadId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.loadId);
    }
}

