/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import java.util.Objects;
import java.util.OptionalDouble;

public abstract class AbstractLoadAction
extends AbstractAction {
    private final boolean relativeValue;
    private final Double activePowerValue;
    private final Double reactivePowerValue;

    AbstractLoadAction(String id, boolean relativeValue, Double activePowerValue, Double reactivePowerValue) {
        super(id);
        this.relativeValue = relativeValue;
        this.activePowerValue = activePowerValue;
        this.reactivePowerValue = reactivePowerValue;
    }

    public boolean isRelativeValue() {
        return this.relativeValue;
    }

    public OptionalDouble getActivePowerValue() {
        return this.activePowerValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.activePowerValue);
    }

    public OptionalDouble getReactivePowerValue() {
        return this.reactivePowerValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.reactivePowerValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractLoadAction that = (AbstractLoadAction)o;
        return this.relativeValue == that.relativeValue && Objects.equals(this.activePowerValue, that.activePowerValue) && Objects.equals(this.reactivePowerValue, that.reactivePowerValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relativeValue, this.activePowerValue, this.reactivePowerValue);
    }
}

