/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.AreaInterchangeTargetModification;
import com.powsybl.iidm.modification.NetworkModification;
import java.util.Objects;

public class AreaInterchangeTargetAction
extends AbstractAction {
    public static final String NAME = "AREA_INTERCHANGE_TARGET_ACTION";
    private final String areaId;
    private final double interchangeTarget;

    public AreaInterchangeTargetAction(String id, String areaId, double interchangeTarget) {
        super(id);
        this.areaId = Objects.requireNonNull(areaId);
        this.interchangeTarget = interchangeTarget;
    }

    public double getInterchangeTarget() {
        return this.interchangeTarget;
    }

    public String getAreaId() {
        return this.areaId;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AreaInterchangeTargetAction that = (AreaInterchangeTargetAction)o;
        return Objects.equals(this.areaId, that.areaId) && (this.interchangeTarget == that.interchangeTarget || Double.isNaN(this.interchangeTarget) && Double.isNaN(that.interchangeTarget));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interchangeTarget, this.areaId);
    }

    @Override
    public NetworkModification toModification() {
        return new AreaInterchangeTargetModification(this.areaId, this.interchangeTarget);
    }
}

