/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractLoadAction;
import com.powsybl.iidm.modification.DanglingLineModification;
import com.powsybl.iidm.modification.NetworkModification;
import java.util.Objects;

public class DanglingLineAction
extends AbstractLoadAction {
    public static final String NAME = "DANGLING_LINE";
    private final String danglingLineId;

    DanglingLineAction(String id, String danglingLineId, boolean relativeValue, Double activePowerValue, Double reactivePowerValue) {
        super(id, relativeValue, activePowerValue, reactivePowerValue);
        this.danglingLineId = Objects.requireNonNull(danglingLineId);
    }

    public String getDanglingLineId() {
        return this.danglingLineId;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public NetworkModification toModification() {
        return new DanglingLineModification(this.getDanglingLineId(), this.isRelativeValue(), (Double)this.getActivePowerValue().stream().boxed().findFirst().orElse(null), (Double)this.getReactivePowerValue().stream().boxed().findFirst().orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DanglingLineAction that = (DanglingLineAction)o;
        return Objects.equals(this.danglingLineId, that.danglingLineId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.danglingLineId);
    }
}

