/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.GeneratorModification;
import com.powsybl.iidm.modification.NetworkModification;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class GeneratorAction
extends AbstractAction {
    public static final String NAME = "GENERATOR";
    private final String generatorId;
    private final Boolean activePowerRelativeValue;
    private final Double activePowerValue;
    private final Boolean voltageRegulatorOn;
    private final Double targetV;
    private final Double targetQ;

    GeneratorAction(String id, String generatorId, Boolean activePowerRelativeValue, Double activePowerValue, Boolean voltageRegulatorOn, Double targetV, Double targetQ) {
        super(id);
        this.generatorId = Objects.requireNonNull(generatorId);
        this.activePowerRelativeValue = activePowerRelativeValue;
        this.activePowerValue = activePowerValue;
        this.voltageRegulatorOn = voltageRegulatorOn;
        this.targetV = targetV;
        this.targetQ = targetQ;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getGeneratorId() {
        return this.generatorId;
    }

    public Optional<Boolean> isActivePowerRelativeValue() {
        return Optional.ofNullable(this.activePowerRelativeValue);
    }

    public OptionalDouble getActivePowerValue() {
        return this.activePowerValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.activePowerValue);
    }

    public Optional<Boolean> isVoltageRegulatorOn() {
        return Optional.ofNullable(this.voltageRegulatorOn);
    }

    public OptionalDouble getTargetV() {
        return this.targetV == null ? OptionalDouble.empty() : OptionalDouble.of(this.targetV);
    }

    public OptionalDouble getTargetQ() {
        return this.targetQ == null ? OptionalDouble.empty() : OptionalDouble.of(this.targetQ);
    }

    @Override
    public NetworkModification toModification() {
        GeneratorModification.Modifs modifs = new GeneratorModification.Modifs();
        modifs.setIgnoreCorrectiveOperations(true);
        this.getActivePowerValue().ifPresent(value -> {
            boolean isRelative = this.isActivePowerRelativeValue().orElse(false);
            if (isRelative) {
                modifs.setDeltaTargetP(Double.valueOf(value));
            } else {
                modifs.setTargetP(Double.valueOf(value));
            }
        });
        this.isVoltageRegulatorOn().ifPresent(arg_0 -> ((GeneratorModification.Modifs)modifs).setVoltageRegulatorOn(arg_0));
        this.getTargetQ().ifPresent(arg_0 -> ((GeneratorModification.Modifs)modifs).setTargetQ(arg_0));
        this.getTargetV().ifPresent(arg_0 -> ((GeneratorModification.Modifs)modifs).setTargetV(arg_0));
        return new GeneratorModification(this.getGeneratorId(), modifs);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeneratorAction that = (GeneratorAction)o;
        return Objects.equals(this.generatorId, that.generatorId) && Objects.equals(this.activePowerRelativeValue, that.activePowerRelativeValue) && Objects.equals(this.activePowerValue, that.activePowerValue) && Objects.equals(this.voltageRegulatorOn, that.voltageRegulatorOn) && Objects.equals(this.targetV, that.targetV) && Objects.equals(this.targetQ, that.targetQ);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.generatorId, this.activePowerRelativeValue, this.activePowerValue, this.voltageRegulatorOn, this.targetV, this.targetQ);
    }
}

