/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.HvdcLineModification;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.network.HvdcLine;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class HvdcAction
extends AbstractAction {
    public static final String NAME = "HVDC";
    private final String hvdcId;
    private final Boolean acEmulationEnabled;
    private final Double activePowerSetpoint;
    private final HvdcLine.ConvertersMode converterMode;
    private final Double droop;
    private final Double p0;
    private final Boolean relativeValue;

    HvdcAction(String id, String hvdcId, Boolean acEmulationEnabled, Double activePowerSetpoint, HvdcLine.ConvertersMode converterMode, Double droop, Double p0, Boolean relativeValue) {
        super(id);
        this.hvdcId = Objects.requireNonNull(hvdcId);
        this.acEmulationEnabled = acEmulationEnabled;
        this.activePowerSetpoint = activePowerSetpoint;
        this.converterMode = converterMode;
        this.droop = droop;
        this.p0 = p0;
        this.relativeValue = relativeValue;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getHvdcId() {
        return this.hvdcId;
    }

    public Optional<HvdcLine.ConvertersMode> getConverterMode() {
        return Optional.ofNullable(this.converterMode);
    }

    public OptionalDouble getDroop() {
        return this.droop == null ? OptionalDouble.empty() : OptionalDouble.of(this.droop);
    }

    public OptionalDouble getActivePowerSetpoint() {
        return this.activePowerSetpoint == null ? OptionalDouble.empty() : OptionalDouble.of(this.activePowerSetpoint);
    }

    public OptionalDouble getP0() {
        return this.p0 == null ? OptionalDouble.empty() : OptionalDouble.of(this.p0);
    }

    public Optional<Boolean> isAcEmulationEnabled() {
        return Optional.ofNullable(this.acEmulationEnabled);
    }

    public Optional<Boolean> isRelativeValue() {
        return Optional.ofNullable(this.relativeValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HvdcAction that = (HvdcAction)o;
        return Objects.equals(this.hvdcId, that.hvdcId) && Objects.equals(this.acEmulationEnabled, that.acEmulationEnabled) && Objects.equals(this.activePowerSetpoint, that.activePowerSetpoint) && this.converterMode == that.converterMode && Objects.equals(this.droop, that.droop) && Objects.equals(this.p0, that.p0) && Objects.equals(this.relativeValue, that.relativeValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hvdcId, this.acEmulationEnabled, this.activePowerSetpoint, this.converterMode, this.droop, this.p0, this.relativeValue);
    }

    @Override
    public NetworkModification toModification() {
        return new HvdcLineModification(this.getHvdcId(), (Boolean)this.isAcEmulationEnabled().orElse(null), (Double)this.getActivePowerSetpoint().stream().boxed().findFirst().orElse(null), (HvdcLine.ConvertersMode)this.getConverterMode().orElse(null), (Double)this.getDroop().stream().boxed().findFirst().orElse(null), (Double)this.getP0().stream().boxed().findFirst().orElse(null), (Boolean)this.isRelativeValue().orElse(null));
    }
}

