/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.ShuntCompensatorModification;
import java.util.Objects;

public class ShuntCompensatorPositionAction
extends AbstractAction {
    public static final String NAME = "SHUNT_COMPENSATOR_POSITION";
    private final String shuntCompensatorId;
    private final int sectionCount;

    ShuntCompensatorPositionAction(String id, String shuntCompensatorId, int sectionCount) {
        super(id);
        this.shuntCompensatorId = Objects.requireNonNull(shuntCompensatorId);
        this.sectionCount = sectionCount;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getShuntCompensatorId() {
        return this.shuntCompensatorId;
    }

    public int getSectionCount() {
        return this.sectionCount;
    }

    @Override
    public NetworkModification toModification() {
        return new ShuntCompensatorModification(this.getShuntCompensatorId(), null, Integer.valueOf(this.getSectionCount()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShuntCompensatorPositionAction that = (ShuntCompensatorPositionAction)o;
        return this.sectionCount == that.sectionCount && Objects.equals(this.shuntCompensatorId, that.shuntCompensatorId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shuntCompensatorId, this.sectionCount);
    }
}

