/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.network.StaticVarCompensator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class StaticVarCompensatorAction
extends AbstractAction {
    public static final String NAME = "STATIC_VAR_COMPENSATOR";
    private final String staticVarCompensatorId;
    private final StaticVarCompensator.RegulationMode regulationMode;
    private final Double voltageSetpoint;
    private final Double reactivePowerSetpoint;

    protected StaticVarCompensatorAction(String id, String staticVarCompensatorId, StaticVarCompensator.RegulationMode regulationMode, Double voltageSetpoint, Double reactivePowerSetpoint) {
        super(id);
        this.staticVarCompensatorId = Objects.requireNonNull(staticVarCompensatorId);
        this.regulationMode = regulationMode;
        this.voltageSetpoint = voltageSetpoint;
        this.reactivePowerSetpoint = reactivePowerSetpoint;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getStaticVarCompensatorId() {
        return this.staticVarCompensatorId;
    }

    public Optional<StaticVarCompensator.RegulationMode> getRegulationMode() {
        return Optional.ofNullable(this.regulationMode);
    }

    public OptionalDouble getVoltageSetpoint() {
        return this.voltageSetpoint == null ? OptionalDouble.empty() : OptionalDouble.of(this.voltageSetpoint);
    }

    public OptionalDouble getReactivePowerSetpoint() {
        return this.reactivePowerSetpoint == null ? OptionalDouble.empty() : OptionalDouble.of(this.reactivePowerSetpoint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StaticVarCompensatorAction that = (StaticVarCompensatorAction)o;
        return Objects.equals(this.staticVarCompensatorId, that.staticVarCompensatorId) && this.regulationMode == that.regulationMode && Objects.equals(this.voltageSetpoint, that.voltageSetpoint) && Objects.equals(this.reactivePowerSetpoint, that.reactivePowerSetpoint);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.staticVarCompensatorId, this.regulationMode, this.voltageSetpoint, this.reactivePowerSetpoint);
    }
}

