/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.CloseSwitch;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.OpenSwitch;
import java.util.Objects;

public class SwitchAction
extends AbstractAction {
    public static final String NAME = "SWITCH";
    private final String switchId;
    private final boolean open;

    public SwitchAction(String id, String switchId, boolean open) {
        super(id);
        this.switchId = Objects.requireNonNull(switchId);
        this.open = open;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getSwitchId() {
        return this.switchId;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public NetworkModification toModification() {
        if (this.isOpen()) {
            return new OpenSwitch(this.getSwitchId());
        }
        return new CloseSwitch(this.getSwitchId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwitchAction that = (SwitchAction)o;
        return this.open == that.open && Objects.equals(this.switchId, that.switchId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.switchId, this.open);
    }
}

