/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.ConnectableConnectionBuilder;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.PlannedDisconnectionBuilder;
import com.powsybl.iidm.network.ThreeSides;
import java.util.Objects;
import java.util.Optional;

public class TerminalsConnectionAction
extends AbstractAction {
    public static final String NAME = "TERMINALS_CONNECTION";
    private final String elementId;
    private ThreeSides side;
    private final boolean open;

    public TerminalsConnectionAction(String id, String elementId, ThreeSides side, boolean open) {
        super(id);
        this.elementId = Objects.requireNonNull(elementId);
        this.side = side;
        this.open = open;
    }

    public TerminalsConnectionAction(String id, String elementId, boolean open) {
        super(id);
        this.elementId = Objects.requireNonNull(elementId);
        this.open = open;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getElementId() {
        return this.elementId;
    }

    public Optional<ThreeSides> getSide() {
        return Optional.ofNullable(this.side);
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public NetworkModification toModification() {
        if (this.isOpen()) {
            PlannedDisconnectionBuilder builder = new PlannedDisconnectionBuilder().withIdentifiableId(this.elementId).withSide(this.side);
            return builder.build();
        }
        ConnectableConnectionBuilder builder = new ConnectableConnectionBuilder().withIdentifiableId(this.elementId).withOnlyBreakersOperable(true).withSide(this.side);
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TerminalsConnectionAction that = (TerminalsConnectionAction)o;
        return this.open == that.open && Objects.equals(this.elementId, that.elementId) && this.side == that.side;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementId, this.side, this.open);
    }
}

