/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.action.AbstractAction;
import com.powsybl.action.AbstractLoadAction;
import java.io.IOException;
import java.io.UncheckedIOException;

public abstract class AbstractLoadActionSerializer<T extends AbstractLoadAction>
extends StdSerializer<T> {
    protected AbstractLoadActionSerializer(Class<T> vc) {
        super(vc);
    }

    protected abstract String getElementIdAttributeName();

    protected abstract String getElementId(T var1);

    public void serialize(T action, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", action.getType());
        jsonGenerator.writeStringField("id", ((AbstractAction)action).getId());
        jsonGenerator.writeStringField(this.getElementIdAttributeName(), this.getElementId(action));
        jsonGenerator.writeBooleanField("relativeValue", ((AbstractLoadAction)action).isRelativeValue());
        ((AbstractLoadAction)action).getActivePowerValue().ifPresent(activePowerValue -> {
            try {
                jsonGenerator.writeNumberField("activePowerValue", activePowerValue);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        ((AbstractLoadAction)action).getReactivePowerValue().ifPresent(reactivePowerValue -> {
            try {
                jsonGenerator.writeNumberField("reactivePowerValue", reactivePowerValue);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        jsonGenerator.writeEndObject();
    }
}

