/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.HvdcActionBuilder;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.HvdcLine;
import java.io.IOException;

public class HvdcActionBuilderDeserializer
extends StdDeserializer<HvdcActionBuilder> {
    public HvdcActionBuilderDeserializer() {
        super(HvdcActionBuilder.class);
    }

    public HvdcActionBuilder deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        HvdcActionBuilder hvdcActionBuilder = new HvdcActionBuilder();
        JsonUtil.parsePolymorphicObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "type": {
                    if (!"HVDC".equals(jsonParser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)jsonParser, (String)"Expected type HVDC");
                    }
                    return true;
                }
                case "id": {
                    hvdcActionBuilder.withId(jsonParser.nextTextValue());
                    return true;
                }
                case "hvdcId": {
                    hvdcActionBuilder.withHvdcId(jsonParser.nextTextValue());
                    return true;
                }
                case "acEmulationEnabled": {
                    jsonParser.nextToken();
                    hvdcActionBuilder.withAcEmulationEnabled(jsonParser.getValueAsBoolean());
                    return true;
                }
                case "activePowerSetpoint": {
                    jsonParser.nextToken();
                    hvdcActionBuilder.withActivePowerSetpoint(jsonParser.getValueAsDouble());
                    return true;
                }
                case "converterMode": {
                    hvdcActionBuilder.withConverterMode(HvdcLine.ConvertersMode.valueOf((String)jsonParser.nextTextValue()));
                    return true;
                }
                case "droop": {
                    jsonParser.nextToken();
                    hvdcActionBuilder.withDroop(jsonParser.getValueAsDouble());
                    return true;
                }
                case "p0": {
                    jsonParser.nextToken();
                    hvdcActionBuilder.withP0(jsonParser.getValueAsDouble());
                    return true;
                }
                case "relativeValue": {
                    jsonParser.nextToken();
                    hvdcActionBuilder.withRelativeValue(jsonParser.getValueAsBoolean());
                    return true;
                }
            }
            return false;
        });
        return hvdcActionBuilder;
    }
}

