/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.Action;
import com.powsybl.action.ActionBuilder;
import com.powsybl.action.ActionList;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class IdentifierActionList
extends ActionList {
    private final Map<ActionBuilder, NetworkElementIdentifier> elementIdentifierMap;

    public IdentifierActionList(List<Action> actions, Map<ActionBuilder, NetworkElementIdentifier> elementIdentifierMap) {
        super(actions);
        this.elementIdentifierMap = elementIdentifierMap;
    }

    public List<Action> getActions(Network network) {
        return Stream.concat(this.elementIdentifierMap.entrySet().stream().map(entry -> {
            Set identifiables = ((NetworkElementIdentifier)entry.getValue()).filterIdentifiable(network);
            if (identifiables.size() != 1) {
                throw new PowsyblException("for identifier in action builder more than one or none network element was found");
            }
            return ((ActionBuilder)entry.getKey()).withNetworkElementId(((Identifiable)identifiables.iterator().next()).getId()).build();
        }), this.getActions().stream()).toList();
    }

    public Map<ActionBuilder, NetworkElementIdentifier> getElementIdentifierMap() {
        return this.elementIdentifierMap;
    }
}

