/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.ActionBuilder;
import com.powsybl.action.GeneratorAction;

public class GeneratorActionBuilder
implements ActionBuilder<GeneratorActionBuilder> {
    private String id;
    private String generatorId;
    private Boolean activePowerRelativeValue;
    private Double activePowerValue;
    private Boolean voltageRegulatorOn;
    private Double targetV;
    private Double targetQ;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public GeneratorActionBuilder withNetworkElementId(String generatorId) {
        this.generatorId = generatorId;
        return this;
    }

    @Override
    public GeneratorAction build() {
        if (this.activePowerRelativeValue != null ^ this.activePowerValue != null) {
            throw new IllegalArgumentException("For a generator action, both or none of these two attributes must be provided: activePowerValue and activePowerRelativeValue");
        }
        return new GeneratorAction(this.id, this.generatorId, this.activePowerRelativeValue, this.activePowerValue, this.voltageRegulatorOn, this.targetV, this.targetQ);
    }

    @Override
    public String getType() {
        return "GENERATOR";
    }

    @Override
    public GeneratorActionBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public GeneratorActionBuilder withGeneratorId(String generatorId) {
        return this.withNetworkElementId(generatorId);
    }

    public GeneratorActionBuilder withActivePowerRelativeValue(boolean activePowerRelativeValue) {
        this.activePowerRelativeValue = activePowerRelativeValue;
        return this;
    }

    public GeneratorActionBuilder withActivePowerValue(double activePowerValue) {
        this.activePowerValue = activePowerValue;
        return this;
    }

    public GeneratorActionBuilder withVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn = voltageRegulatorOn;
        return this;
    }

    public GeneratorActionBuilder withTargetV(double targetV) {
        this.targetV = targetV;
        return this;
    }

    public GeneratorActionBuilder withTargetQ(double targetQ) {
        this.targetQ = targetQ;
        return this;
    }
}

