/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.action.Action;
import com.powsybl.action.ActionBuilder;
import com.powsybl.action.ActionList;
import com.powsybl.action.IdentifierActionList;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionListDeserializer
extends StdDeserializer<ActionList> {
    public static final String VERSION = "version";

    public ActionListDeserializer() {
        super(ActionList.class);
    }

    public ActionList deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parseObject((JsonParser)parser, fieldName -> {
            switch (fieldName) {
                case "version": {
                    context.version = parser.nextTextValue();
                    deserializationContext.setAttribute((Object)VERSION, (Object)context.version);
                    return true;
                }
                case "actions": {
                    parser.nextToken();
                    List actionBuilders = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, ActionBuilder.class);
                    context.actions = actionBuilders.stream().map(ActionBuilder::build).toList();
                    return true;
                }
                case "elementIdentifiers": {
                    parser.nextToken();
                    context.elementIdentifierMap = (Map)parser.readValueAs((TypeReference)new TypeReference<HashMap<String, NetworkElementIdentifier>>(){});
                    return true;
                }
                case "actionBuilders": {
                    parser.nextToken();
                    context.actionBuilderMap = (Map)parser.readValueAs((TypeReference)new TypeReference<HashMap<String, ActionBuilder>>(){});
                    return true;
                }
            }
            return false;
        });
        if (context.version == null) {
            throw new JsonMappingException((Closeable)parser, "version is missing");
        }
        JsonUtil.assertSupportedVersion((String)"actions", (String)context.version, (String)"1.2");
        if (!context.actionBuilderMap.isEmpty()) {
            if (context.elementIdentifierMap.size() != context.actionBuilderMap.size()) {
                throw new IOException("map elementIdentifiers and actionBuilders must have the same size");
            }
            if (!context.actionBuilderMap.keySet().containsAll(context.elementIdentifierMap.keySet())) {
                throw new IOException("keys in elementIdentifiers are different from actionBuilders");
            }
            HashMap<ActionBuilder, NetworkElementIdentifier> actionBuilderNetworkElementIdentifierMap = new HashMap<ActionBuilder, NetworkElementIdentifier>();
            context.elementIdentifierMap.forEach((actionId, identifier) -> actionBuilderNetworkElementIdentifierMap.put(context.actionBuilderMap.get(actionId), (NetworkElementIdentifier)identifier));
            return new IdentifierActionList(context.actions, actionBuilderNetworkElementIdentifierMap);
        }
        return new ActionList(context.actions);
    }

    public static class ParsingContext {
        String version;
        List<Action> actions;
        Map<String, NetworkElementIdentifier> elementIdentifierMap = new HashMap<String, NetworkElementIdentifier>();
        Map<String, ActionBuilder> actionBuilderMap = new HashMap<String, ActionBuilder>();
    }
}

