/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.action.ActionBuilder;
import com.powsybl.action.ActionList;
import com.powsybl.action.IdentifierActionList;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionListSerializer
extends StdSerializer<ActionList> {
    public ActionListSerializer() {
        super(ActionList.class);
    }

    public void serialize(ActionList actionList, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("version", "1.2");
        serializerProvider.defaultSerializeField("actions", actionList.getActions(), jsonGenerator);
        if (actionList instanceof IdentifierActionList) {
            IdentifierActionList identifierActionList = (IdentifierActionList)actionList;
            serializerProvider.defaultSerializeField("elementIdentifiers", identifierActionList.getElementIdentifierMap().entrySet().stream().collect(Collectors.toMap(map -> ((ActionBuilder)map.getKey()).getId(), Map.Entry::getValue)), jsonGenerator);
            serializerProvider.defaultSerializeField("actionBuilders", identifierActionList.getElementIdentifierMap().entrySet().stream().collect(Collectors.toMap(map -> ((ActionBuilder)map.getKey()).getId(), Map.Entry::getKey)), jsonGenerator);
        }
        jsonGenerator.writeEndObject();
    }
}

