/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action;

import com.powsybl.action.AbstractAction;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.PercentChangeLoadModification;
import java.util.Objects;

public class PercentChangeLoadAction
extends AbstractAction {
    public static final String NAME = "PCT_LOAD_CHANGE";
    private String loadId;
    private Double p0PercentChange;
    private QModificationStrategy qModificationStrategy;

    PercentChangeLoadAction(String id, String loadId, Double p0PercentChange, QModificationStrategy qModificationStrategy) {
        super(id);
        this.loadId = loadId;
        this.p0PercentChange = p0PercentChange;
        this.qModificationStrategy = qModificationStrategy;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public Double getP0PercentChange() {
        return this.p0PercentChange;
    }

    public String getLoadId() {
        return this.loadId;
    }

    public QModificationStrategy getQModificationStrategy() {
        return this.qModificationStrategy;
    }

    @Override
    public NetworkModification toModification() {
        double q0PercentChange = switch (this.qModificationStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case QModificationStrategy.CONSTANT_Q -> 0.0;
            case QModificationStrategy.CONSTANT_PQ_RATIO -> this.p0PercentChange;
        };
        return new PercentChangeLoadModification(this.loadId, this.p0PercentChange.doubleValue(), q0PercentChange);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PercentChangeLoadAction that = (PercentChangeLoadAction)o;
        return Objects.equals(this.loadId, that.loadId) && Objects.equals(this.p0PercentChange, that.p0PercentChange) && this.qModificationStrategy == that.qModificationStrategy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.loadId, this.p0PercentChange, this.qModificationStrategy});
    }

    public static enum QModificationStrategy {
        CONSTANT_Q,
        CONSTANT_PQ_RATIO;

    }
}

