/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.ial.dsl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.network.Network;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Action {
    private final String id;
    private String description;
    private final List<NetworkModification> modifications;

    public Action(String id) {
        this(id, new ArrayList<NetworkModification>());
    }

    public Action(String id, List<NetworkModification> modifications) {
        this.id = Objects.requireNonNull(id);
        this.modifications = Objects.requireNonNull(modifications);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<NetworkModification> getModifications() {
        return this.modifications;
    }

    public void run(Network network, boolean throwException, ComputationManager computationManager) {
        for (NetworkModification task : this.modifications) {
            task.apply(network, throwException, computationManager, ReportNode.NO_OP);
        }
    }

    public void run(Network network, ComputationManager computationManager) {
        this.run(network, true, computationManager);
    }

    public void run(Network network) {
        for (NetworkModification task : this.modifications) {
            task.apply(network, true, ReportNode.NO_OP);
        }
    }

    public void run(Network network, boolean throwException) {
        for (NetworkModification task : this.modifications) {
            task.apply(network, throwException, ReportNode.NO_OP);
        }
    }
}

