/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.ial.dsl;

import com.powsybl.action.ial.dsl.Action;
import com.powsybl.action.ial.dsl.ActionDslException;
import com.powsybl.action.ial.dsl.Rule;
import com.powsybl.contingency.Contingency;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ActionDb {
    private final Map<String, Contingency> contingencies = new LinkedHashMap<String, Contingency>();
    private final Map<String, Rule> rules = new LinkedHashMap<String, Rule>();
    private final Map<String, Action> actions = new LinkedHashMap<String, Action>();
    private static final String EXCEPTION_MESSAGE = "' is defined several times";

    public void addContingency(Contingency contingency) {
        Objects.requireNonNull(contingency);
        String id = contingency.getId();
        if (this.contingencies.containsKey(id)) {
            throw new ActionDslException("Contingency '" + id + EXCEPTION_MESSAGE);
        }
        this.contingencies.put(contingency.getId(), contingency);
    }

    public Collection<Contingency> getContingencies() {
        return this.contingencies.values();
    }

    public Collection<Action> getActions() {
        return this.actions.values();
    }

    public Contingency getContingency(String id) {
        Objects.requireNonNull(id);
        Contingency contingency = this.contingencies.get(id);
        if (contingency == null) {
            throw new ActionDslException("Contingency '" + id + "' not found");
        }
        return contingency;
    }

    public void addRule(Rule rule) {
        Objects.requireNonNull(rule);
        String id = rule.getId();
        if (this.rules.containsKey(id)) {
            throw new ActionDslException("Rule '" + id + EXCEPTION_MESSAGE);
        }
        this.rules.put(id, rule);
    }

    public Collection<Rule> getRules() {
        return this.rules.values();
    }

    public void addAction(Action action) {
        Objects.requireNonNull(action);
        String id = action.getId();
        if (this.actions.containsKey(id)) {
            throw new ActionDslException("Action '" + id + EXCEPTION_MESSAGE);
        }
        this.actions.put(id, action);
    }

    public Action getAction(String id) {
        Objects.requireNonNull(id);
        Action action = this.actions.get(id);
        if (action == null) {
            throw new ActionDslException("Action '" + id + "' not found");
        }
        return action;
    }

    void checkUndefinedActions() {
        Set referencedActionsIds = this.rules.values().stream().flatMap(r -> r.getActions().stream()).collect(Collectors.toSet());
        String strActionIds = referencedActionsIds.stream().filter(id -> !this.actions.containsKey(id)).collect(Collectors.joining(", "));
        if (!strActionIds.isEmpty()) {
            throw new ActionDslException("Actions [" + strActionIds + "] not found");
        }
    }
}

