/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.ial.dsl;

import com.powsybl.action.ial.dsl.Condition;
import com.powsybl.action.ial.dsl.RuleType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Rule {
    private final String id;
    private String description;
    private final Condition condition;
    private final int life;
    private final List<String> actions;
    private final RuleType type;

    public Rule(String id, Condition condition, int life, String ... actions) {
        this(id, condition, life, Arrays.asList(actions));
    }

    public Rule(String id, Condition condition, int life, List<String> actions) {
        this(id, condition, life, RuleType.APPLY, actions);
    }

    public Rule(String id, Condition condition, int life, RuleType type, String ... actions) {
        this(id, condition, life, type, Arrays.asList(actions));
    }

    public Rule(String id, Condition condition, int life, RuleType type, List<String> actions) {
        if (life < 0) {
            throw new IllegalArgumentException("Invalid life value, has to be >= 0");
        }
        this.id = Objects.requireNonNull(id);
        this.condition = Objects.requireNonNull(condition);
        this.type = Objects.requireNonNull(type);
        if (type.equals((Object)RuleType.TEST) && life != 1) {
            throw new IllegalArgumentException("Invalid life value, has to be 1 in test rule.");
        }
        this.life = life;
        this.actions = Objects.requireNonNull(actions);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public int getLife() {
        return this.life;
    }

    public List<String> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public RuleType getType() {
        return this.type;
    }
}

