/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.ial.dsl.ast;

import com.powsybl.action.ial.dsl.ast.ActionExpressionVisitor;
import com.powsybl.action.ial.dsl.ast.ActionTakenNode;
import com.powsybl.action.ial.dsl.ast.AllOverloadedNode;
import com.powsybl.action.ial.dsl.ast.ContingencyOccurredNode;
import com.powsybl.action.ial.dsl.ast.EvaluationContext;
import com.powsybl.action.ial.dsl.ast.IsOverloadedNode;
import com.powsybl.action.ial.dsl.ast.LoadingRankNode;
import com.powsybl.action.ial.dsl.ast.MostLoadedNode;
import com.powsybl.action.ial.dsl.ast.NetworkComponentNode;
import com.powsybl.action.ial.dsl.ast.NetworkMethodNode;
import com.powsybl.action.ial.dsl.ast.NetworkPropertyNode;
import com.powsybl.commons.PowsyblException;
import com.powsybl.dsl.GroovyUtil;
import com.powsybl.dsl.ast.ExpressionEvaluator;
import com.powsybl.dsl.ast.ExpressionNode;
import com.powsybl.dsl.ast.ExpressionVisitor;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.TwoSides;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ActionExpressionEvaluator
extends ExpressionEvaluator
implements ActionExpressionVisitor<Object, Void> {
    private final EvaluationContext context;

    public ActionExpressionEvaluator(EvaluationContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public static Object evaluate(ExpressionNode node, EvaluationContext context) {
        return node.accept((ExpressionVisitor)new ActionExpressionEvaluator(context), null);
    }

    @Override
    public Object visitNetworkComponent(NetworkComponentNode node, Void arg) {
        Identifiable identifiable = this.context.getNetwork().getIdentifiable(node.getComponentId());
        if (identifiable == null) {
            throw new PowsyblException("Network component '" + node.getComponentId() + "' not found");
        }
        return identifiable;
    }

    @Override
    public Object visitNetworkProperty(NetworkPropertyNode node, Void arg) {
        Object parentValue = node.getParent().accept((ExpressionVisitor)this, (Object)arg);
        if (parentValue == null) {
            throw new PowsyblException("Cannot call a property '" + node.getPropertyName() + "' on a null object");
        }
        return GroovyUtil.callProperty((Object)parentValue, (String)node.getPropertyName());
    }

    @Override
    public Object visitNetworkMethod(NetworkMethodNode node, Void arg) {
        Object parentValue = node.getParent().accept((ExpressionVisitor)this, (Object)arg);
        if (parentValue == null) {
            throw new PowsyblException("Cannot call a method '" + node.getMethodName() + "' on a null object");
        }
        return GroovyUtil.callMethod((Object)parentValue, (String)node.getMethodName(), (Object[])node.getArgs());
    }

    @Override
    public Object visitActionTaken(ActionTakenNode node, Void arg) {
        return this.context.isActionTaken(node.getActionId());
    }

    @Override
    public Object visitContingencyOccurred(ContingencyOccurredNode node, Void arg) {
        return this.context.getContingency() != null && (node.getContingencyId() == null || this.context.getContingency().getId().equals(node.getContingencyId()));
    }

    private List<String> sortBranches(List<String> branchIds) {
        return branchIds.stream().map(this::getBranch).map(branch -> {
            BranchAndSide branchAndSide1 = new BranchAndSide((Branch)branch, TwoSides.ONE);
            BranchAndSide branchAndSide2 = new BranchAndSide((Branch)branch, TwoSides.TWO);
            int c = branchAndSide1.compareTo(branchAndSide2);
            return c >= 0 ? branchAndSide1 : branchAndSide2;
        }).sorted().map(branchAndSide -> branchAndSide.getBranch().getId()).collect(Collectors.toList());
    }

    @Override
    public Object visitLoadingRank(LoadingRankNode node, Void arg) {
        ArrayList<String> branchIds = new ArrayList<String>();
        node.getBranchIds().forEach(e -> branchIds.add((String)e.accept((ExpressionVisitor)this, (Object)arg)));
        String branchIdToRank = (String)node.getBranchIdToRankNode().accept((ExpressionVisitor)this, (Object)arg);
        if (!branchIds.contains(branchIdToRank)) {
            throw new PowsyblException("Branch to rank has to be in the list");
        }
        List<String> sortedBranchIds = this.sortBranches(branchIds);
        int i = sortedBranchIds.indexOf(branchIdToRank);
        if (i == -1) {
            throw new IllegalStateException();
        }
        return sortedBranchIds.size() - i;
    }

    @Override
    public Object visitMostLoaded(MostLoadedNode node, Void arg) {
        List<String> sortedBranchIds = this.sortBranches(node.getBranchIds());
        return sortedBranchIds.get(sortedBranchIds.size() - 1);
    }

    @Override
    public Object visitIsOverloaded(IsOverloadedNode isOverloadedNode, Void arg) {
        double limitReduction = isOverloadedNode.getLimitReduction();
        return isOverloadedNode.getBranchIds().stream().map(id -> this.getBranch((String)id).isOverloaded(limitReduction)).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public Object visitAllOverloaded(AllOverloadedNode allOverloadedNode, Void arg) {
        double limitReduction = allOverloadedNode.getLimitReduction();
        return allOverloadedNode.getBranchIds().stream().map(id -> this.getBranch((String)id).isOverloaded(limitReduction)).reduce(true, (a, b) -> a != false && b != false);
    }

    private Branch getBranch(String branchId) {
        Branch branch = this.context.getNetwork().getBranch(branchId);
        if (branch == null) {
            throw new PowsyblException("Branch '" + branchId + "' not found");
        }
        return branch;
    }

    private static final class BranchAndSide
    implements Comparable<BranchAndSide> {
        private final Branch branch;
        private final TwoSides side;

        private BranchAndSide(Branch branch, TwoSides side) {
            this.branch = Objects.requireNonNull(branch);
            this.side = Objects.requireNonNull(side);
        }

        private Branch getBranch() {
            return this.branch;
        }

        private TwoSides getSide() {
            return this.side;
        }

        private static double getPermanentLimit(Branch<?> branch, TwoSides side) {
            Objects.requireNonNull(branch);
            Objects.requireNonNull(side);
            double permanentLimit1 = branch.getCurrentLimits1().map(LoadingLimits::getPermanentLimit).orElse(Double.NaN);
            double permanentLimit2 = branch.getCurrentLimits2().map(LoadingLimits::getPermanentLimit).orElse(Double.NaN);
            return side == TwoSides.ONE ? permanentLimit1 : permanentLimit2;
        }

        private static int compare(double value1, double value2) {
            if (Double.isNaN(value1) && Double.isNaN(value2)) {
                return 0;
            }
            if (Double.isNaN(value1) && !Double.isNaN(value2)) {
                return -1;
            }
            if (!Double.isNaN(value1) && Double.isNaN(value2)) {
                return 1;
            }
            return Double.compare(value1, value2);
        }

        private static int compare(BranchAndSide branchAndSide1, BranchAndSide branchAndSide2) {
            int c;
            Overload overload1 = branchAndSide1.getBranch().checkTemporaryLimits(branchAndSide1.getSide(), LimitType.CURRENT);
            Overload overload2 = branchAndSide2.getBranch().checkTemporaryLimits(branchAndSide2.getSide(), LimitType.CURRENT);
            double i1 = branchAndSide1.getBranch().getTerminal(branchAndSide1.getSide()).getI();
            double i2 = branchAndSide2.getBranch().getTerminal(branchAndSide2.getSide()).getI();
            double permanentLimit1 = BranchAndSide.getPermanentLimit(branchAndSide1.getBranch(), branchAndSide1.getSide());
            double permanentLimit2 = BranchAndSide.getPermanentLimit(branchAndSide2.getBranch(), branchAndSide2.getSide());
            if (overload1 == null) {
                c = overload2 == null ? BranchAndSide.compare(i1 / permanentLimit1, i2 / permanentLimit2) : -1;
            } else if (overload2 == null) {
                c = 1;
            } else {
                c = -Integer.compare(overload1.getTemporaryLimit().getAcceptableDuration(), overload2.getTemporaryLimit().getAcceptableDuration());
                if (c == 0) {
                    c = BranchAndSide.compare(i1 / overload1.getTemporaryLimit().getValue(), i2 / overload2.getTemporaryLimit().getValue());
                }
            }
            return c;
        }

        public int hashCode() {
            return Objects.hash(this.branch, this.side);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BranchAndSide) {
                BranchAndSide branchAndSide = (BranchAndSide)obj;
                return branchAndSide.compareTo(this) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(BranchAndSide o) {
            return BranchAndSide.compare(this, o);
        }

        public String toString() {
            return this.branch.getId() + "/" + this.side;
        }
    }
}

