/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.action.ial.dsl.ast;

import com.powsybl.action.ial.dsl.ast.ActionExpressionVisitor;
import com.powsybl.action.ial.dsl.ast.ActionTakenNode;
import com.powsybl.action.ial.dsl.ast.AllOverloadedNode;
import com.powsybl.action.ial.dsl.ast.ContingencyOccurredNode;
import com.powsybl.action.ial.dsl.ast.IsOverloadedNode;
import com.powsybl.action.ial.dsl.ast.LoadingRankNode;
import com.powsybl.action.ial.dsl.ast.MostLoadedNode;
import com.powsybl.action.ial.dsl.ast.NetworkComponentNode;
import com.powsybl.action.ial.dsl.ast.NetworkMethodNode;
import com.powsybl.action.ial.dsl.ast.NetworkPropertyNode;
import com.powsybl.dsl.ast.ExpressionNode;
import com.powsybl.dsl.ast.ExpressionPrinter;
import com.powsybl.dsl.ast.ExpressionVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;

public class ActionExpressionPrinter
extends ExpressionPrinter
implements ActionExpressionVisitor<Void, Void> {
    public static String toString(ExpressionNode node) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            ActionExpressionPrinter.write(node, writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        writer.close();
        return string;
    }

    private static void write(ExpressionNode node, StringWriter out) {
        node.accept((ExpressionVisitor)new ActionExpressionPrinter(out), null);
    }

    public static void print(ExpressionNode node) {
        ActionExpressionPrinter.print(node, System.out);
    }

    public static void print(ExpressionNode node, OutputStream out) {
        node.accept((ExpressionVisitor)new ActionExpressionPrinter(out), null);
    }

    public static void print(ExpressionNode node, OutputStream out, Charset cs) {
        node.accept((ExpressionVisitor)new ActionExpressionPrinter(out, cs), null);
    }

    public ActionExpressionPrinter(Writer out) {
        super(out);
    }

    public ActionExpressionPrinter(OutputStream out) {
        super(out);
    }

    public ActionExpressionPrinter(OutputStream out, Charset cs) {
        super(out, cs);
    }

    @Override
    public Void visitNetworkComponent(NetworkComponentNode node, Void arg) {
        switch (node.getComponentType()) {
            case BRANCH: {
                this.out.write("branch");
                break;
            }
            case LINE: {
                this.out.write("line");
                break;
            }
            case TRANSFORMER: {
                this.out.write("transformer");
                break;
            }
            case GENERATOR: {
                this.out.write("generator");
                break;
            }
            case LOAD: {
                this.out.write("load");
                break;
            }
            case SWITCH: {
                this.out.write("switch_");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.out.write("('");
        this.out.write(node.getComponentId());
        this.out.write("')");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitNetworkProperty(NetworkPropertyNode node, Void arg) {
        node.getParent().accept((ExpressionVisitor)this, (Object)arg);
        this.out.write(".");
        this.out.write(node.getPropertyName());
        this.out.flush();
        return null;
    }

    @Override
    public Void visitNetworkMethod(NetworkMethodNode node, Void arg) {
        node.getParent().accept((ExpressionVisitor)this, (Object)arg);
        this.out.write(".");
        this.out.write(node.getMethodName());
        this.out.write("(");
        for (int i = 0; i < node.getArgs().length; ++i) {
            Object arg2 = node.getArgs()[i];
            this.out.write(arg2.toString());
            if (i >= node.getArgs().length - 1) continue;
            this.out.write(", ");
        }
        this.out.write(")");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitActionTaken(ActionTakenNode node, Void arg) {
        this.out.write("actionTaken('");
        this.out.write(node.getActionId());
        this.out.write("')");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitContingencyOccurred(ContingencyOccurredNode node, Void arg) {
        this.out.write("contingencyOccurred(");
        if (node.getContingencyId() != null) {
            this.out.write("'");
            this.out.write(node.getContingencyId());
            this.out.write("'");
        }
        this.out.write(")");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitLoadingRank(LoadingRankNode node, Void arg) {
        this.out.write("loadingRank('");
        node.getBranchIdToRankNode().accept((ExpressionVisitor)this, (Object)arg);
        this.out.write("', [");
        Iterator<ExpressionNode> it = node.getBranchIds().iterator();
        while (it.hasNext()) {
            this.out.write("'");
            it.next().accept((ExpressionVisitor)this, (Object)arg);
            this.out.write("'");
            if (!it.hasNext()) continue;
            this.out.write(", ");
        }
        this.out.write("])");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitMostLoaded(MostLoadedNode node, Void arg) {
        this.out.write("mostLoaded(");
        this.out.write("['");
        this.out.write(String.join((CharSequence)"', '", node.getBranchIds()));
        this.out.write("'])");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitIsOverloaded(IsOverloadedNode node, Void arg) {
        this.out.write("isOverloaded(");
        this.out.write("['");
        this.out.write(String.join((CharSequence)"', '", node.getBranchIds()));
        this.out.write("'])");
        this.out.flush();
        return null;
    }

    @Override
    public Void visitAllOverloaded(AllOverloadedNode node, Void arg) {
        this.out.write("allOverloaded(");
        this.out.write("['");
        this.out.write(String.join((CharSequence)"', '", node.getBranchIds()));
        this.out.write("'])");
        this.out.flush();
        return null;
    }
}

