/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;

public final class CgmesReports {
    private CgmesReports() {
    }

    public static void importedCgmesNetworkReport(ReportNode reportNode, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("importedCgmesNetwork", "CGMES network ${networkId} is imported.")).withUntypedValue("networkId", networkId)).withSeverity(TypedValue.INFO_SEVERITY)).add();
    }

    public static void badVoltageTargetValueRegulatingControlReport(ReportNode reportNode, String eqId, double targetValue) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("badVoltageTargetValueRegulatingControl", "Equipment ${equipmentId} has a regulating control with bad target value for voltage: ${targetValue}")).withUntypedValue("equipmentId", eqId)).withTypedValue("targetValue", targetValue, "VOLTAGE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void badTargetDeadbandRegulatingControlReport(ReportNode reportNode, String eqId, double targetDeadband) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("badTargetDeadbandRegulatingControl", "Equipment ${equipmentId} has a regulating control with bad target deadband: ${targetDeadband}")).withUntypedValue("equipmentId", eqId)).withTypedValue("targetDeadband", targetDeadband, "VOLTAGE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void invalidAngleVoltageBusReport(ReportNode reportNode, Bus bus, String nodeId, double v, double angle) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("invalidAngleVoltageBus", "Node ${nodeId} in substation ${substation}, voltageLevel ${voltageLevel}, bus ${bus} has invalid value for voltage and/or angle. Voltage magnitude is ${voltage}, angle is ${angle}")).withUntypedValue("substation", bus.getVoltageLevel().getSubstation().map(Identifiable::getNameOrId).orElse("unknown"))).withUntypedValue("voltageLevel", bus.getVoltageLevel().getNameOrId())).withUntypedValue("bus", bus.getId())).withUntypedValue("nodeId", nodeId)).withTypedValue("voltage", v, "VOLTAGE")).withTypedValue("angle", angle, "ANGLE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void invalidAngleVoltageNodeReport(ReportNode reportNode, String nodeId, double v, double angle) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("invalidAngleVoltageNode", "Node ${nodeId} has invalid value for voltage and/or angle. Voltage magnitude is ${voltage}, angle is ${angle}")).withUntypedValue("nodeId", nodeId)).withTypedValue("voltage", v, "VOLTAGE")).withTypedValue("angle", angle, "ANGLE")).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void inconsistentProfilesTPRequiredReport(ReportNode reportNode, String networkId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("inconsistentProfilesTPRequired", "Network contains node/breaker ${networkId} information. References to Topological Nodes in SSH/SV files will not be valid if TP is not exported.")).withUntypedValue("networkId", networkId)).withSeverity(TypedValue.ERROR_SEVERITY)).add();
    }

    public static void danglingLineDisconnectedAtBoundaryHasBeenDisconnectedReport(ReportNode reportNode, String danglingLineId) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("danglingLineDisconnectedAtBoundaryHasBeenDisconnected", "DanglingLine ${danglingLineId} was connected at network side and disconnected at boundary side. It has been disconnected also at network side.")).withUntypedValue("danglingLineId", danglingLineId)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }

    public static void multipleUnpairedDanglingLinesAtSameBoundaryReport(ReportNode reportNode, String danglingLineId, double p0, double q0, double p0Adjusted, double q0Adjusted) {
        ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("multipleUnpairedDanglingLinesAtSameBoundary", "Multiple unpaired DanglingLines were connected at the same boundary side. Adjusted original injection from (${p0}, ${q0}) to (${p0Adjusted}, ${q0Adjusted}) for dangling line ${danglingLineId}.")).withUntypedValue("danglingLineId", danglingLineId)).withUntypedValue("p0", p0)).withUntypedValue("q0", q0)).withUntypedValue("p0Adjusted", p0Adjusted)).withUntypedValue("q0Adjusted", q0Adjusted)).withSeverity(TypedValue.WARN_SEVERITY)).add();
    }
}

