/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.BoundaryEquipment;
import com.powsybl.cgmes.conversion.CgmesConversionContextExtensionAdder;
import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.conversion.CgmesImportPostProcessor;
import com.powsybl.cgmes.conversion.CgmesImportPreProcessor;
import com.powsybl.cgmes.conversion.CgmesModelExtensionAdder;
import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingTerminalMapper;
import com.powsybl.cgmes.conversion.ReportTapChangers;
import com.powsybl.cgmes.conversion.elements.ACLineSegmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractObjectConversion;
import com.powsybl.cgmes.conversion.elements.AsynchronousMachineConversion;
import com.powsybl.cgmes.conversion.elements.BusbarSectionConversion;
import com.powsybl.cgmes.conversion.elements.EnergyConsumerConversion;
import com.powsybl.cgmes.conversion.elements.EnergySourceConversion;
import com.powsybl.cgmes.conversion.elements.EquipmentAtBoundaryConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentBranchConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentInjectionConversion;
import com.powsybl.cgmes.conversion.elements.EquivalentShuntConversion;
import com.powsybl.cgmes.conversion.elements.ExternalNetworkInjectionConversion;
import com.powsybl.cgmes.conversion.elements.GroundConversion;
import com.powsybl.cgmes.conversion.elements.NodeConversion;
import com.powsybl.cgmes.conversion.elements.OperationalLimitConversion;
import com.powsybl.cgmes.conversion.elements.SeriesCompensatorConversion;
import com.powsybl.cgmes.conversion.elements.ShuntConversion;
import com.powsybl.cgmes.conversion.elements.StaticVarCompensatorConversion;
import com.powsybl.cgmes.conversion.elements.SubstationConversion;
import com.powsybl.cgmes.conversion.elements.SvInjectionConversion;
import com.powsybl.cgmes.conversion.elements.SwitchConversion;
import com.powsybl.cgmes.conversion.elements.SynchronousMachineConversion;
import com.powsybl.cgmes.conversion.elements.VoltageLevelConversion;
import com.powsybl.cgmes.conversion.elements.hvdc.CgmesDcConversion;
import com.powsybl.cgmes.conversion.elements.transformers.ThreeWindingsTransformerConversion;
import com.powsybl.cgmes.conversion.elements.transformers.TwoWindingsTransformerConversion;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.extensions.BaseVoltageMappingAdder;
import com.powsybl.cgmes.extensions.CgmesControlArea;
import com.powsybl.cgmes.extensions.CgmesControlAreas;
import com.powsybl.cgmes.extensions.CgmesControlAreasAdder;
import com.powsybl.cgmes.extensions.CgmesMetadataModelsAdder;
import com.powsybl.cgmes.extensions.CgmesTopologyKind;
import com.powsybl.cgmes.extensions.CimCharacteristicsAdder;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesNamespace;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.triplestore.CgmesModelTripleStore;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversion {
    private final CgmesModel cgmes;
    private final Config config;
    private final List<CgmesImportPostProcessor> postProcessors;
    private final List<CgmesImportPreProcessor> preProcessors;
    private final NetworkFactory networkFactory;
    private static final Logger LOG = LoggerFactory.getLogger(Conversion.class);
    private static final String VOLTAGE_LEVEL = "VoltageLevel";
    public static final String NETWORK_PS_CGMES_MODEL_DETAIL = "CGMESModelDetail";
    public static final String NETWORK_PS_CGMES_MODEL_DETAIL_BUS_BRANCH = "bus-branch";
    public static final String NETWORK_PS_CGMES_MODEL_DETAIL_NODE_BREAKER = "node-breaker";
    public static final String CGMES_PREFIX_ALIAS_PROPERTIES = "CGMES.";
    public static final String PROPERTY_IS_CREATED_FOR_DISCONNECTED_TERMINAL = "CGMES.isCreatedForDisconnectedTerminal";
    public static final String PROPERTY_IS_EQUIVALENT_SHUNT = "CGMES.isEquivalentShunt";
    public static final String PROPERTY_HYDRO_PLANT_STORAGE_TYPE = "CGMES.hydroPlantStorageKind";
    public static final String PROPERTY_FOSSIL_FUEL_TYPE = "CGMES.fuelType";
    public static final String PROPERTY_CGMES_ORIGINAL_CLASS = "CGMES.originalClass";
    public static final String PROPERTY_BUSBAR_SECTION_TERMINALS = "CGMES.busbarSectionTerminals";
    public static final String PROPERTY_CGMES_GOVERNOR_SCD = "CGMES.governorSCD";
    public static final String PROPERTY_CGMES_SYNCHRONOUS_MACHINE_TYPE = "CGMES.synchronousMachineType";
    public static final String PROPERTY_CGMES_SYNCHRONOUS_MACHINE_OPERATING_MODE = "CGMES.synchronousMachineOperatingMode";

    public Conversion(CgmesModel cgmes) {
        this(cgmes, new Config());
    }

    public Conversion(CgmesModel cgmes, Config config) {
        this(cgmes, config, Collections.emptyList(), Collections.emptyList());
    }

    public Conversion(CgmesModel cgmes, Config config, List<CgmesImportPostProcessor> postProcessors) {
        this(cgmes, config, Collections.emptyList(), postProcessors, NetworkFactory.findDefault());
    }

    public Conversion(CgmesModel cgmes, Config config, List<CgmesImportPreProcessor> preProcessors, List<CgmesImportPostProcessor> postProcessors) {
        this(cgmes, config, preProcessors, postProcessors, NetworkFactory.findDefault());
    }

    public Conversion(CgmesModel cgmes, Config config, List<CgmesImportPreProcessor> activatedPreProcessors, List<CgmesImportPostProcessor> activatedPostProcessors, NetworkFactory networkFactory) {
        this.cgmes = Objects.requireNonNull(cgmes);
        this.config = Objects.requireNonNull(config);
        this.preProcessors = Objects.requireNonNull(activatedPreProcessors);
        this.postProcessors = Objects.requireNonNull(activatedPostProcessors);
        this.networkFactory = Objects.requireNonNull(networkFactory);
    }

    public void report(Consumer<String> out) {
        new ReportTapChangers(this.cgmes, out).report();
    }

    public Network convert() {
        return this.convert(ReportNode.NO_OP);
    }

    public Network convert(ReportNode reportNode) {
        Objects.requireNonNull(reportNode);
        for (CgmesImportPreProcessor preProcessor : this.preProcessors) {
            preProcessor.process(this.cgmes);
        }
        if (LOG.isTraceEnabled() && this.cgmes.baseVoltages() != null) {
            LOG.trace("{}{}{}", new Object[]{"BaseVoltages", System.lineSeparator(), this.cgmes.baseVoltages().tabulate()});
        }
        if (!this.cgmes.hasEquipmentCore()) {
            throw new CgmesModelException("Data source does not contain EquipmentCore data");
        }
        Network network = this.createNetwork();
        Context context = this.createContext(network, reportNode);
        this.assignNetworkProperties(context);
        this.addMetadataModels(network, context);
        this.addCimCharacteristics(network);
        BaseVoltageMappingAdder bvAdder = (BaseVoltageMappingAdder)network.newExtension(BaseVoltageMappingAdder.class);
        this.cgmes.baseVoltages().forEach(bv -> bvAdder.addBaseVoltage(bv.getId("BaseVoltage"), bv.asDouble("nominalVoltage"), this.isBoundaryBaseVoltage(bv.getLocal("graph"))));
        bvAdder.add();
        this.cgmes.computedTerminals().forEach(t -> context.terminalMapping().buildTopologicalNodeCgmesTerminalsMapping((CgmesTerminal)t));
        this.cgmes.regulatingControls().forEach(p -> context.regulatingControlMapping().cacheRegulatingControls((PropertyBag)p));
        this.convert(this.cgmes.substations(), s -> new SubstationConversion((PropertyBag)s, context));
        this.convert(this.cgmes.voltageLevels(), vl -> new VoltageLevelConversion((PropertyBag)vl, context));
        this.createFictitiousVoltageLevelsForLineContainers(context);
        PropertyBags nodes = context.nodeBreaker() ? this.cgmes.connectivityNodes() : this.cgmes.topologicalNodes();
        String nodeTypeName = context.nodeBreaker() ? "ConnectivityNode" : "TopologicalNode";
        this.convert(nodes, n -> new NodeConversion(nodeTypeName, (PropertyBag)n, context));
        if (!context.config().createBusbarSectionForEveryConnectivityNode()) {
            this.convert(this.cgmes.busBarSections(), bbs -> new BusbarSectionConversion((PropertyBag)bbs, context));
        }
        this.convert(this.cgmes.grounds(), g -> new GroundConversion((PropertyBag)g, context));
        this.convert(this.cgmes.energyConsumers(), ec -> new EnergyConsumerConversion((PropertyBag)ec, context));
        this.convert(this.cgmes.energySources(), es -> new EnergySourceConversion((PropertyBag)es, context));
        Function<PropertyBag, AbstractObjectConversion> convf = eqi -> new EquivalentInjectionConversion((PropertyBag)eqi, context);
        this.convert(this.cgmes.equivalentInjections(), convf);
        convf = eni -> new ExternalNetworkInjectionConversion((PropertyBag)eni, context);
        this.convert(this.cgmes.externalNetworkInjections(), convf);
        this.convert(this.cgmes.shuntCompensators(), sh -> new ShuntConversion((PropertyBag)sh, context));
        this.convert(this.cgmes.equivalentShunts(), es -> new EquivalentShuntConversion((PropertyBag)es, context));
        convf = svc -> new StaticVarCompensatorConversion((PropertyBag)svc, context);
        this.convert(this.cgmes.staticVarCompensators(), convf);
        convf = asm -> new AsynchronousMachineConversion((PropertyBag)asm, context);
        this.convert(this.cgmes.asynchronousMachines(), convf);
        this.convert(this.cgmes.synchronousMachinesGenerators(), sm -> new SynchronousMachineConversion((PropertyBag)sm, context));
        this.convert(this.cgmes.synchronousMachinesCondensers(), sm -> new SynchronousMachineConversion((PropertyBag)sm, context));
        HashSet<String> delayedBoundaryNodes = new HashSet<String>();
        this.convertSwitches(context, delayedBoundaryNodes);
        this.convertACLineSegmentsToLines(context, delayedBoundaryNodes);
        this.convertEquivalentBranchesToLines(context, delayedBoundaryNodes);
        this.convert(this.cgmes.seriesCompensators(), sc -> new SeriesCompensatorConversion((PropertyBag)sc, context));
        this.convertTransformers(context, delayedBoundaryNodes);
        delayedBoundaryNodes.forEach(node -> this.convertEquipmentAtBoundaryNode(context, (String)node));
        CgmesDcConversion cgmesDcConversion = new CgmesDcConversion(this.cgmes, context);
        cgmesDcConversion.convert();
        this.convert(this.cgmes.operationalLimits(), l -> new OperationalLimitConversion((PropertyBag)l, context));
        context.loadingLimitsMapping().addAll();
        if (this.config.convertSvInjections()) {
            this.convert(this.cgmes.svInjections(), si -> new SvInjectionConversion((PropertyBag)si, context));
        }
        this.clearUnattachedHvdcConverterStations(network, context);
        this.voltageAngles(nodes, context);
        if (this.config.importControlAreas()) {
            ((CgmesControlAreasAdder)network.newExtension(CgmesControlAreasAdder.class)).add();
            CgmesControlAreas cgmesControlAreas = (CgmesControlAreas)network.getExtension(CgmesControlAreas.class);
            this.cgmes.controlAreas().forEach(ca -> Conversion.createControlArea(cgmesControlAreas, ca));
            this.cgmes.tieFlows().forEach(tf -> Conversion.addTieFlow(context, cgmesControlAreas, tf));
            cgmesControlAreas.cleanIfEmpty();
        }
        context.regulatingControlMapping().setAllRegulatingControls(network);
        if (context.config().debugTopology()) {
            this.debugTopology(context);
        }
        if (this.config.storeCgmesModelAsNetworkExtension()) {
            ((CgmesModelExtensionAdder)network.newExtension(CgmesModelExtensionAdder.class)).withModel(this.cgmes).add();
        }
        this.handleDangingLineDisconnectedAtBoundary(network, context);
        this.adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode(network, context);
        for (CgmesImportPostProcessor postProcessor : this.postProcessors) {
            postProcessor.process(network, this.cgmes.tripleStore());
        }
        Conversion.completeVoltagesAndAngles(network);
        if (this.config.storeCgmesConversionContextAsNetworkExtension()) {
            ((CgmesConversionContextExtensionAdder)network.newExtension(CgmesConversionContextExtensionAdder.class)).withContext(context).add();
        }
        CgmesReports.importedCgmesNetworkReport(context.getReportNode(), network.getId());
        return network;
    }

    private void handleDangingLineDisconnectedAtBoundary(Network network, Context context) {
        if (this.config.disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected()) {
            for (DanglingLine dl : network.getDanglingLines()) {
                String terminalBoundaryId = dl.getAliasFromType("CGMES.Terminal_Boundary").orElse(null);
                if (terminalBoundaryId == null) {
                    LOG.warn("Dangling line {}: alias for terminal at boundary is missing", (Object)dl.getId());
                    continue;
                }
                this.disconnectDanglingLineAtBounddary(dl, terminalBoundaryId, context);
            }
        }
    }

    private void disconnectDanglingLineAtBounddary(DanglingLine dl, String terminalBoundaryId, Context context) {
        CgmesTerminal terminalBoundary = this.cgmes.terminal(terminalBoundaryId);
        if (terminalBoundary == null) {
            LOG.warn("Dangling line {}: terminal at boundary with id {} is not found in CGMES model", (Object)dl.getId(), (Object)terminalBoundaryId);
        } else if (!terminalBoundary.connected() && dl.getTerminal().isConnected()) {
            LOG.warn("DanglingLine {} was connected at network side and disconnected at boundary side. It has been disconnected also at network side.", (Object)dl.getId());
            CgmesReports.danglingLineDisconnectedAtBoundaryHasBeenDisconnectedReport(context.getReportNode(), dl.getId());
            dl.getTerminal().disconnect();
        }
    }

    private void adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode(Network network, Context context) {
        network.getDanglingLineStream(DanglingLineFilter.UNPAIRED).filter(dl -> dl.getTerminal().isConnected()).collect(Collectors.groupingBy(Conversion::getDanglingLineBoundaryNode)).values().stream().filter(dls -> dls.size() > 1).forEach(dls -> this.adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode((List<DanglingLine>)dls, context));
    }

    private void adjustMultipleUnpairedDanglingLinesAtSameBoundaryNode(List<DanglingLine> dls, Context context) {
        double p0 = dls.get(0).getP0();
        double q0 = dls.get(0).getQ0();
        long count = dls.size();
        double p0Adjusted = p0 / (double)count;
        double q0Adjusted = q0 / (double)count;
        dls.forEach(dl -> {
            LOG.warn("Multiple unpaired DanglingLines were connected at the same boundary side. Adjusted original injection from ({}, {}) to ({}, {}) for dangling line {}.", new Object[]{p0, q0, p0Adjusted, q0Adjusted, dl.getId()});
            CgmesReports.multipleUnpairedDanglingLinesAtSameBoundaryReport(context.getReportNode(), dl.getId(), p0, q0, p0Adjusted, q0Adjusted);
            dl.setP0(p0Adjusted);
            dl.setQ0(q0Adjusted);
        });
    }

    public static String getDanglingLineBoundaryNode(DanglingLine dl) {
        String node = dl.getProperty("CGMES.ConnectivityNode_Boundary");
        if (node == null) {
            node = dl.getProperty("CGMES.TopologicalNode_Boundary");
        }
        if (node == null) {
            LOG.warn("Dangling line {} does not have a boundary node identifier.", (Object)dl.getId());
            node = "unknown";
        }
        return node;
    }

    private Source isBoundaryBaseVoltage(String graph) {
        return graph.contains("EQ") && graph.contains("BD") ? Source.BOUNDARY : Source.IGM;
    }

    private static void completeVoltagesAndAngles(Network network) {
        network.getThreeWindingsTransformers().forEach(ThreeWindingsTransformerConversion::calculateVoltageAndAngleInStarBus);
        network.getDanglingLineStream(DanglingLineFilter.UNPAIRED).forEach(AbstractConductingEquipmentConversion::calculateVoltageAndAngleInBoundaryBus);
        network.getTieLines().forEach(tieLine -> AbstractConductingEquipmentConversion.calculateVoltageAndAngleInBoundaryBus(tieLine.getDanglingLine1(), tieLine.getDanglingLine2()));
    }

    private static void createControlArea(CgmesControlAreas cgmesControlAreas, PropertyBag ca) {
        String controlAreaId = ca.getId("ControlArea");
        cgmesControlAreas.newCgmesControlArea().setId(controlAreaId).setName(ca.getLocal("name")).setEnergyIdentificationCodeEic(ca.getLocal("energyIdentCodeEic")).setNetInterchange(ca.asDouble("netInterchange", Double.NaN)).setPTolerance(ca.asDouble("pTolerance", Double.NaN)).add();
    }

    private static void addTieFlow(Context context, CgmesControlAreas cgmesControlAreas, PropertyBag tf) {
        String controlAreaId = tf.getId("ControlArea");
        CgmesControlArea cgmesControlArea = cgmesControlAreas.getCgmesControlArea(controlAreaId);
        if (cgmesControlArea == null) {
            context.ignored("Tie Flow", String.format("Tie Flow %s refers to a non-existing control area", tf.getId("TieFlow")));
            return;
        }
        String terminalId = tf.getId("terminal");
        Boundary boundary = context.terminalMapping().findBoundary(terminalId, context.cgmes());
        if (boundary != null) {
            cgmesControlArea.add(boundary);
            return;
        }
        RegulatingTerminalMapper.mapForTieFlow(terminalId, context).ifPresent(arg_0 -> ((CgmesControlArea)cgmesControlArea).add(arg_0));
    }

    private void convert(PropertyBags elements, Function<PropertyBag, AbstractObjectConversion> f) {
        String logTitle = null;
        for (PropertyBag element : elements) {
            AbstractObjectConversion c = f.apply(element);
            if (LOG.isTraceEnabled()) {
                if (logTitle == null) {
                    logTitle = c.getClass().getSimpleName();
                    logTitle = logTitle.replace("Conversion", "");
                }
                LOG.trace(element.tabulateLocals(logTitle));
            }
            if (c.insideBoundary()) {
                c.convertInsideBoundary();
                continue;
            }
            if (!c.valid()) continue;
            c.convert();
        }
    }

    private Network createNetwork() {
        String networkId = this.cgmes.modelId();
        String sourceFormat = "CGMES";
        return this.networkFactory.createNetwork(networkId, sourceFormat);
    }

    private Context createContext(Network network, ReportNode reportNode) {
        Context context = new Context(this.cgmes, this.config, network, reportNode);
        context.substationIdMapping().build();
        context.dc().initialize();
        context.loadRatioTapChangers();
        context.loadPhaseTapChangers();
        context.loadRatioTapChangerTables();
        context.loadPhaseTapChangerTables();
        context.loadReactiveCapabilityCurveData();
        return context;
    }

    private void assignNetworkProperties(Context context) {
        context.network().setProperty(NETWORK_PS_CGMES_MODEL_DETAIL, context.nodeBreaker() ? NETWORK_PS_CGMES_MODEL_DETAIL_NODE_BREAKER : NETWORK_PS_CGMES_MODEL_DETAIL_BUS_BRANCH);
        PropertyBags modelProfiles = context.cgmes().modelProfiles();
        String fullModel = "FullModel";
        modelProfiles.sort(Comparator.comparing(p -> p.getId(fullModel)));
        for (PropertyBag modelProfile : modelProfiles) {
            String profile;
            if (modelProfile.getId(fullModel).equals(context.network().getId()) || (profile = CgmesNamespace.getProfile((String)modelProfile.getId("profile"))) == null || "EQ_OP".equals(profile) || "SV".equals(profile)) continue;
            context.network().setProperty(Identifiables.getUniqueId((String)(CGMES_PREFIX_ALIAS_PROPERTIES + profile + "_ID"), property -> context.network().hasProperty(property)), modelProfile.getId(fullModel));
        }
        ZonedDateTime modelScenarioTime = this.cgmes.scenarioTime();
        ZonedDateTime modelCreated = this.cgmes.created();
        long forecastDistance = Duration.between(modelCreated, modelScenarioTime).toMinutes();
        context.network().setForecastDistance(forecastDistance >= 0L ? (int)forecastDistance : 0);
        context.network().setCaseDate(modelScenarioTime);
        LOG.info("cgmes scenarioTime       : {}", (Object)modelScenarioTime);
        LOG.info("cgmes modelCreated       : {}", (Object)modelCreated);
        LOG.info("network caseDate         : {}", (Object)context.network().getCaseDate());
        LOG.info("network forecastDistance : {}", (Object)context.network().getForecastDistance());
    }

    private void addMetadataModels(Network network, Context context) {
        PropertyBags ps = this.cgmes.fullModels();
        if (ps.isEmpty()) {
            return;
        }
        CgmesMetadataModelsAdder modelsAdder = (CgmesMetadataModelsAdder)network.newExtension(CgmesMetadataModelsAdder.class);
        for (PropertyBag p : ps) {
            CgmesMetadataModelsAdder.ModelAdder modelAdder = modelsAdder.newModel().setId(p.getId("FullModel")).setSubset(this.subsetFromGraph(p.getLocal("graph"))).setDescription(p.getId("description")).setVersion(this.readVersion(p, context)).setModelingAuthoritySet(p.getId("modelingAuthoritySet"));
            this.addMetadataModelReferences(p, "profileList", arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addProfile(arg_0));
            this.addMetadataModelReferences(p, "dependentOnList", arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addDependentOn(arg_0));
            this.addMetadataModelReferences(p, "supersedesList", arg_0 -> ((CgmesMetadataModelsAdder.ModelAdder)modelAdder).addSupersedes(arg_0));
            modelAdder.add();
        }
        modelsAdder.add();
    }

    private void addMetadataModelReferences(PropertyBag p, String refsProperty, Function<String, CgmesMetadataModelsAdder.ModelAdder> adder) {
        String refs = (String)p.get((Object)refsProperty);
        if (refs != null && !refs.isEmpty()) {
            for (String ref : refs.split(" ")) {
                adder.apply(ref);
            }
        }
    }

    private CgmesSubset subsetFromGraph(String graph) {
        return Stream.of(CgmesSubset.values()).filter(subset -> subset.isValidName(graph)).findFirst().orElse(CgmesSubset.UNKNOWN);
    }

    private int readVersion(PropertyBag propertyBag, Context context) {
        try {
            return propertyBag.asInt("version");
        }
        catch (NumberFormatException e) {
            context.fixed("Version", "The version is expected to be an integer: " + (String)propertyBag.get((Object)"version") + ". Fixed to 1");
            return 1;
        }
    }

    private void addCimCharacteristics(Network network) {
        CgmesModel cgmesModel = this.cgmes;
        if (cgmesModel instanceof CgmesModelTripleStore) {
            CgmesModelTripleStore cgmesModelTripleStore = (CgmesModelTripleStore)cgmesModel;
            ((CimCharacteristicsAdder)network.newExtension(CimCharacteristicsAdder.class)).setTopologyKind(this.cgmes.isNodeBreaker() ? CgmesTopologyKind.NODE_BREAKER : CgmesTopologyKind.BUS_BRANCH).setCimVersion(cgmesModelTripleStore.getCimVersion()).add();
        }
    }

    private void putVoltageLevelRefByLineContainerIdIfPresent(String lineContainerId, Supplier<String> terminalId1, Supplier<String> terminalId2, Map<String, VoltageLevel> nominalVoltageByLineContainerId, Context context) {
        VoltageLevel vl;
        String vlId = Optional.ofNullable(context.namingStrategy().getIidmId(VOLTAGE_LEVEL, context.cgmes().voltageLevel(this.cgmes.terminal(terminalId1.get()), context.nodeBreaker()))).orElseGet(() -> context.namingStrategy().getIidmId(VOLTAGE_LEVEL, context.cgmes().voltageLevel(this.cgmes.terminal((String)terminalId2.get()), context.nodeBreaker())));
        if (vlId != null && (vl = context.network().getVoltageLevel(vlId)) != null) {
            nominalVoltageByLineContainerId.put(lineContainerId, vl);
        }
    }

    private void convertACLineSegmentsToLines(Context context, Set<String> delayedBoundaryNodes) {
        for (PropertyBag line : this.cgmes.acLineSegments()) {
            ACLineSegmentConversion c;
            if (LOG.isTraceEnabled()) {
                LOG.trace(line.tabulateLocals("ACLineSegment"));
            }
            if (!(c = new ACLineSegmentConversion(line, context)).valid()) continue;
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addAcLineSegmentAtNode(line, node);
                delayedBoundaryNodes.add(node);
                continue;
            }
            c.convert();
        }
    }

    private void createFictitiousVoltageLevelsForLineContainers(Context context) {
        String lineContainerId;
        HashMap<String, VoltageLevel> voltageLevelRefByLineContainerId = new HashMap<String, VoltageLevel>();
        PropertyBags acLineSegments = this.cgmes.acLineSegments();
        for (PropertyBag line : acLineSegments) {
            lineContainerId = line.getId("Line");
            if (lineContainerId == null || voltageLevelRefByLineContainerId.containsKey(lineContainerId)) continue;
            this.putVoltageLevelRefByLineContainerIdIfPresent(lineContainerId, () -> line.getId("Terminal1"), () -> line.getId("Terminal2"), voltageLevelRefByLineContainerId, context);
        }
        for (PropertyBag line : acLineSegments) {
            lineContainerId = line.getId("Line");
            if (lineContainerId == null) continue;
            VoltageLevel vlRef = (VoltageLevel)voltageLevelRefByLineContainerId.get(lineContainerId);
            if (vlRef != null) {
                this.createLineContainerFictitiousVoltageLevels(context, lineContainerId, vlRef, line);
                continue;
            }
            LOG.error("No fictitious Voltage Level created for Line container {}. No voltage level reference could be found", (Object)lineContainerId);
        }
    }

    public static String getFictitiousVoltageLevelForNodeInContainer(String containerId, String nodeId) {
        LOG.trace("Fictitious voltage level id for container {} node {}", (Object)containerId, (Object)nodeId);
        return nodeId + "_VL";
    }

    private LineContainerFictitiousVoltageLevelData voltageLevelDataForACLSinLineContainer(Context context, String lineId, PropertyBag lineSegment, String terminalRef) {
        LineContainerFictitiousVoltageLevelData vldata = new LineContainerFictitiousVoltageLevelData();
        vldata.lineId = lineId;
        vldata.lineName = (String)lineSegment.get((Object)"lineName");
        CgmesTerminal t = this.cgmes.terminal(lineSegment.getId(terminalRef));
        vldata.nodeId = context.nodeBreaker() ? t.connectivityNode() : t.topologicalNode();
        String vlId = context.namingStrategy().getIidmId(VOLTAGE_LEVEL, context.cgmes().voltageLevel(t, context.nodeBreaker()));
        vldata.vl = context.network().getVoltageLevel(Objects.requireNonNullElseGet(vlId, () -> Conversion.getFictitiousVoltageLevelForNodeInContainer(vldata.lineId, vldata.nodeId)));
        return vldata;
    }

    private void createLineContainerFictitiousVoltageLevels(Context context, String lineId, VoltageLevel vlRef, PropertyBag lineSegment) {
        LineContainerFictitiousVoltageLevelData vldata1 = this.voltageLevelDataForACLSinLineContainer(context, lineId, lineSegment, "Terminal1");
        LineContainerFictitiousVoltageLevelData vldata2 = this.voltageLevelDataForACLSinLineContainer(context, lineId, lineSegment, "Terminal2");
        if (vldata1.vl == null && !context.boundary().containsNode(vldata1.nodeId)) {
            this.createLineContainerFictitiousVoltageLevel(context, vldata1, vlRef);
        }
        if (vldata2.vl == null && !context.boundary().containsNode(vldata2.nodeId)) {
            this.createLineContainerFictitiousVoltageLevel(context, vldata2, vlRef);
        }
    }

    private void createLineContainerFictitiousVoltageLevel(Context context, LineContainerFictitiousVoltageLevelData vldata, VoltageLevel vlref) {
        String id = Conversion.getFictitiousVoltageLevelForNodeInContainer(vldata.lineId, vldata.nodeId);
        LOG.warn("Fictitious Voltage Level {} created for Line container {} name {} node {}", new Object[]{id, vldata.lineId, vldata.lineName, vldata.nodeId});
        VoltageLevel vl = ((VoltageLevelAdder)((VoltageLevelAdder)((VoltageLevelAdder)context.network().newVoltageLevel().setNominalV(vlref.getNominalV()).setTopologyKind(context.nodeBreaker() ? TopologyKind.NODE_BREAKER : TopologyKind.BUS_BREAKER).setLowVoltageLimit(vlref.getLowVoltageLimit()).setHighVoltageLimit(vlref.getHighVoltageLimit()).setId(id)).setName(vldata.lineName)).setEnsureIdUnicity(context.config().isEnsureIdAliasUnicity())).add();
        vl.setProperty("CGMES.LineContainerId", vldata.lineId);
    }

    private void convertSwitches(Context context, Set<String> delayedBoundaryNodes) {
        for (PropertyBag sw : this.cgmes.switches()) {
            SwitchConversion c;
            if (LOG.isTraceEnabled()) {
                LOG.trace(sw.tabulateLocals("Switch"));
            }
            if (!(c = new SwitchConversion(sw, context)).valid()) continue;
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addSwitchAtNode(sw, node);
                delayedBoundaryNodes.add(node);
                continue;
            }
            c.convert();
        }
    }

    private void convertEquivalentBranchesToLines(Context context, Set<String> delayedBoundaryNodes) {
        for (PropertyBag equivalentBranch : this.cgmes.equivalentBranches()) {
            EquivalentBranchConversion c;
            if (LOG.isTraceEnabled()) {
                LOG.trace(equivalentBranch.tabulateLocals("EquivalentBranch"));
            }
            if (!(c = new EquivalentBranchConversion(equivalentBranch, context)).valid()) continue;
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addEquivalentBranchAtNode(equivalentBranch, node);
                delayedBoundaryNodes.add(node);
                continue;
            }
            c.convert();
        }
    }

    private void convertTransformers(Context context, Set<String> delayedBoundaryNodes) {
        this.cgmes.groupedTransformerEnds().forEach((t, ends) -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Transformer {}, {}-winding", t, (Object)ends.size());
                ends.forEach(e -> LOG.trace(e.tabulateLocals("TransformerEnd")));
            }
            if (ends.size() == 2) {
                Conversion.convertTwoWindingsTransformers(context, ends, delayedBoundaryNodes);
            } else if (ends.size() == 3) {
                Conversion.convertThreeWindingsTransformers(context, ends);
            } else {
                String what = "PowerTransformer " + t;
                Supplier<String> reason = () -> String.format("Has %d ends. Only 2 or 3 ends are supported", ends.size());
                context.invalid(what, reason);
            }
        });
    }

    private static void convertTwoWindingsTransformers(Context context, PropertyBags ends, Set<String> delayedBoundaryNodes) {
        TwoWindingsTransformerConversion c = new TwoWindingsTransformerConversion(ends, context);
        if (((AbstractConductingEquipmentConversion)c).valid()) {
            String node = c.boundaryNode();
            if (node != null && !context.config().convertBoundary()) {
                context.boundary().addTransformerAtNode(ends, node);
                delayedBoundaryNodes.add(node);
            } else {
                ((AbstractObjectConversion)c).convert();
            }
        }
    }

    private static void convertThreeWindingsTransformers(Context context, PropertyBags ends) {
        ThreeWindingsTransformerConversion c = new ThreeWindingsTransformerConversion(ends, context);
        if (c.valid()) {
            ((AbstractObjectConversion)c).convert();
        }
    }

    private void convertEquipmentAtBoundaryNode(Context context, String node) {
        int numEquipmentsAtNode;
        List<BoundaryEquipment> beqs = context.boundary().boundaryEquipmentAtNode(node);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delayed boundary node {} with {} equipment at it", (Object)node, (Object)beqs.size());
            beqs.forEach(BoundaryEquipment::log);
        }
        if ((numEquipmentsAtNode = beqs.size()) == 1) {
            beqs.get(0).createConversion(context).convertAtBoundary();
        } else if (numEquipmentsAtNode == 2) {
            Conversion.convertTwoEquipmentsAtBoundaryNode(context, node, beqs.get(0), beqs.get(1));
        } else if (numEquipmentsAtNode > 2) {
            List<BoundaryEquipment> connectedBeqs = beqs.stream().filter(beq -> !beq.isAcLineSegmentDisconnected(context)).toList();
            if (connectedBeqs.size() == 2) {
                Conversion.convertTwoEquipmentsAtBoundaryNode(context, node, connectedBeqs.get(0), connectedBeqs.get(1));
                beqs.stream().filter(beq -> !connectedBeqs.contains(beq)).toList().forEach(beq -> {
                    context.fixed("convertEquipmentAtBoundaryNode", String.format("Multiple AcLineSegments at boundary %s. Disconnected AcLineSegment %s is imported as a dangling line.", node, beq.getAcLineSegmentId()));
                    beq.createConversion(context).convertAtBoundary();
                });
            } else {
                context.fixed(node, "More than two connected AcLineSegments at boundary: only dangling lines are created. Please note that the converted IIDM network will probably not be equivalent to the CGMES network.");
                beqs.forEach(beq -> beq.createConversion(context).convertAtBoundary());
            }
        }
    }

    private static void convertTwoEquipmentsAtBoundaryNode(Context context, String node, BoundaryEquipment beq1, BoundaryEquipment beq2) {
        EquipmentAtBoundaryConversion conversion1 = beq1.createConversion(context);
        EquipmentAtBoundaryConversion conversion2 = beq2.createConversion(context);
        conversion1.convertAtBoundary();
        Optional<DanglingLine> dl1 = conversion1.getDanglingLine();
        conversion2.convertAtBoundary();
        Optional<DanglingLine> dl2 = conversion2.getDanglingLine();
        if (dl1.isPresent() && dl2.isPresent()) {
            String regionName1 = Conversion.obtainRegionName(dl1.get().getTerminal().getVoltageLevel());
            String regionName2 = Conversion.obtainRegionName(dl2.get().getTerminal().getVoltageLevel());
            String pairingKey1 = dl1.get().getPairingKey();
            String pairingKey2 = dl2.get().getPairingKey();
            if (pairingKey1 == null || !pairingKey1.equals(pairingKey2)) {
                context.ignored(node, "Both dangling lines do not have the same pairingKey: we do not consider them as a merged line");
            } else if (regionName1 != null && regionName1.equals(regionName2)) {
                context.ignored(node, "Both dangling lines are in the same voltage level: we do not consider them as a merged line");
            } else if (dl2.get().getId().compareTo(dl1.get().getId()) >= 0) {
                ACLineSegmentConversion.convertToTieLine(context, dl1.get(), dl2.get());
            } else {
                ACLineSegmentConversion.convertToTieLine(context, dl2.get(), dl1.get());
            }
        }
    }

    private static String obtainRegionName(VoltageLevel voltageLevel) {
        return voltageLevel.getSubstation().map(s -> s.getProperty("CGMES.regionName")).orElse(null);
    }

    private void voltageAngles(PropertyBags nodes, Context context) {
        if (context.nodeBreaker()) {
            for (PropertyBag n : nodes) {
                NodeConversion nc = new NodeConversion("ConnectivityNode", n, context);
                if (nc.insideBoundary() && (!nc.insideBoundary() || !context.config().convertBoundary())) continue;
                nc.setVoltageAngleNodeBreaker();
            }
        }
    }

    private void clearUnattachedHvdcConverterStations(Network network, Context context) {
        network.getHvdcConverterStationStream().filter(converter -> converter.getHvdcLine() == null).forEach(converter -> {
            context.ignored("HVDC Converter Station " + converter.getId(), "No correct linked HVDC line found.");
            converter.remove();
        });
    }

    private void debugTopology(Context context) {
        context.network().getVoltageLevels().forEach(vl -> {
            Object name = vl.getSubstation().map(s -> s.getNameOrId() + "-").orElse("") + vl.getNameOrId();
            name = ((String)name).replace('/', '-');
            Path file = Paths.get(System.getProperty("java.io.tmpdir"), "temp-cgmes-" + (String)name + ".dot");
            try {
                vl.exportTopology(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static class Config {
        private boolean convertBoundary = false;
        private boolean createBusbarSectionForEveryConnectivityNode = false;
        private boolean convertSvInjections = true;
        private StateProfile profileForInitialValuesShuntSectionsTapPositions = StateProfile.SSH;
        private boolean storeCgmesModelAsNetworkExtension = true;
        private boolean storeCgmesConversionContextAsNetworkExtension = false;
        private boolean createActivePowerControlExtension = false;
        private CgmesImport.FictitiousSwitchesCreationMode createFictitiousSwitchesForDisconnectedTerminalsMode = CgmesImport.FictitiousSwitchesCreationMode.ALWAYS;
        private boolean ensureIdAliasUnicity = false;
        private boolean importControlAreas = true;
        private boolean importNodeBreakerAsBusBreaker = false;
        private boolean disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected = true;
        private NamingStrategy namingStrategy = new NamingStrategy.Identity();
        private Xfmr2RatioPhaseInterpretationAlternative xfmr2RatioPhase = Xfmr2RatioPhaseInterpretationAlternative.END1_END2;
        private Xfmr2ShuntInterpretationAlternative xfmr2Shunt = Xfmr2ShuntInterpretationAlternative.END1_END2;
        private Xfmr2StructuralRatioInterpretationAlternative xfmr2StructuralRatio = Xfmr2StructuralRatioInterpretationAlternative.X;
        private Xfmr3RatioPhaseInterpretationAlternative xfmr3RatioPhase = Xfmr3RatioPhaseInterpretationAlternative.NETWORK_SIDE;
        private Xfmr3ShuntInterpretationAlternative xfmr3Shunt = Xfmr3ShuntInterpretationAlternative.NETWORK_SIDE;
        private Xfmr3StructuralRatioInterpretationAlternative xfmr3StructuralRatio = Xfmr3StructuralRatioInterpretationAlternative.STAR_BUS_SIDE;
        private double missingPermanentLimitPercentage = 100.0;

        public List<String> substationIdsExcludedFromMapping() {
            return Collections.emptyList();
        }

        public boolean debugTopology() {
            return false;
        }

        public boolean importNodeBreakerAsBusBreaker() {
            return this.importNodeBreakerAsBusBreaker;
        }

        public Config setImportNodeBreakerAsBusBreaker(boolean importNodeBreakerAsBusBreaker) {
            this.importNodeBreakerAsBusBreaker = importNodeBreakerAsBusBreaker;
            return this;
        }

        public boolean convertBoundary() {
            return this.convertBoundary;
        }

        public Config setConvertBoundary(boolean convertBoundary) {
            this.convertBoundary = convertBoundary;
            return this;
        }

        public boolean computeFlowsAtBoundaryDanglingLines() {
            return true;
        }

        public boolean createBusbarSectionForEveryConnectivityNode() {
            return this.createBusbarSectionForEveryConnectivityNode;
        }

        public Config setCreateBusbarSectionForEveryConnectivityNode(boolean b) {
            this.createBusbarSectionForEveryConnectivityNode = b;
            return this;
        }

        public boolean convertSvInjections() {
            return this.convertSvInjections;
        }

        public Config setConvertSvInjections(boolean convertSvInjections) {
            this.convertSvInjections = convertSvInjections;
            return this;
        }

        public StateProfile getProfileForInitialValuesShuntSectionsTapPositions() {
            return this.profileForInitialValuesShuntSectionsTapPositions;
        }

        public Config setProfileForInitialValuesShuntSectionsTapPositions(String profileForInitialValuesShuntSectionsTapPositions) {
            switch (Objects.requireNonNull(profileForInitialValuesShuntSectionsTapPositions)) {
                case "SSH": 
                case "SV": {
                    this.profileForInitialValuesShuntSectionsTapPositions = StateProfile.valueOf(profileForInitialValuesShuntSectionsTapPositions);
                    break;
                }
                default: {
                    throw new CgmesModelException("Unexpected profile used for shunt sections / tap positions state hypothesis: " + profileForInitialValuesShuntSectionsTapPositions);
                }
            }
            return this;
        }

        public boolean storeCgmesModelAsNetworkExtension() {
            return this.storeCgmesModelAsNetworkExtension;
        }

        public Config setStoreCgmesModelAsNetworkExtension(boolean storeCgmesModelAsNetworkExtension) {
            this.storeCgmesModelAsNetworkExtension = storeCgmesModelAsNetworkExtension;
            return this;
        }

        public boolean storeCgmesConversionContextAsNetworkExtension() {
            return this.storeCgmesConversionContextAsNetworkExtension;
        }

        public Config setStoreCgmesConversionContextAsNetworkExtension(boolean storeCgmesTerminalMappingAsNetworkExtension) {
            this.storeCgmesConversionContextAsNetworkExtension = storeCgmesTerminalMappingAsNetworkExtension;
            return this;
        }

        public boolean createActivePowerControlExtension() {
            return this.createActivePowerControlExtension;
        }

        public Config setCreateActivePowerControlExtension(boolean createActivePowerControlExtension) {
            this.createActivePowerControlExtension = createActivePowerControlExtension;
            return this;
        }

        public boolean isEnsureIdAliasUnicity() {
            return this.ensureIdAliasUnicity;
        }

        public Config setEnsureIdAliasUnicity(boolean ensureIdAliasUnicity) {
            this.ensureIdAliasUnicity = ensureIdAliasUnicity;
            return this;
        }

        public boolean importControlAreas() {
            return this.importControlAreas;
        }

        public Config setImportControlAreas(boolean importControlAreas) {
            this.importControlAreas = importControlAreas;
            return this;
        }

        public NamingStrategy getNamingStrategy() {
            return this.namingStrategy;
        }

        public Config setNamingStrategy(NamingStrategy namingStrategy) {
            this.namingStrategy = Objects.requireNonNull(namingStrategy);
            return this;
        }

        public Xfmr2RatioPhaseInterpretationAlternative getXfmr2RatioPhase() {
            return this.xfmr2RatioPhase;
        }

        public void setXfmr2RatioPhase(Xfmr2RatioPhaseInterpretationAlternative alternative) {
            this.xfmr2RatioPhase = alternative;
        }

        public Xfmr2ShuntInterpretationAlternative getXfmr2Shunt() {
            return this.xfmr2Shunt;
        }

        public void setXfmr2Shunt(Xfmr2ShuntInterpretationAlternative alternative) {
            this.xfmr2Shunt = alternative;
        }

        public Xfmr2StructuralRatioInterpretationAlternative getXfmr2StructuralRatio() {
            return this.xfmr2StructuralRatio;
        }

        public void setXfmr2StructuralRatio(Xfmr2StructuralRatioInterpretationAlternative alternative) {
            this.xfmr2StructuralRatio = alternative;
        }

        public Xfmr3RatioPhaseInterpretationAlternative getXfmr3RatioPhase() {
            return this.xfmr3RatioPhase;
        }

        public void setXfmr3RatioPhase(Xfmr3RatioPhaseInterpretationAlternative alternative) {
            this.xfmr3RatioPhase = alternative;
        }

        public Xfmr3ShuntInterpretationAlternative getXfmr3Shunt() {
            return this.xfmr3Shunt;
        }

        public void setXfmr3Shunt(Xfmr3ShuntInterpretationAlternative alternative) {
            this.xfmr3Shunt = alternative;
        }

        public Xfmr3StructuralRatioInterpretationAlternative getXfmr3StructuralRatio() {
            return this.xfmr3StructuralRatio;
        }

        public void setXfmr3StructuralRatio(Xfmr3StructuralRatioInterpretationAlternative alternative) {
            this.xfmr3StructuralRatio = alternative;
        }

        public double getMissingPermanentLimitPercentage() {
            return this.missingPermanentLimitPercentage;
        }

        public Config setMissingPermanentLimitPercentage(double missingPermanentLimitPercentage) {
            if (missingPermanentLimitPercentage < 0.0 || missingPermanentLimitPercentage > 100.0) {
                throw new IllegalArgumentException("Missing permanent limit percentage must be between 0 and 100.");
            }
            this.missingPermanentLimitPercentage = missingPermanentLimitPercentage;
            return this;
        }

        public CgmesImport.FictitiousSwitchesCreationMode getCreateFictitiousSwitchesForDisconnectedTerminalsMode() {
            return this.createFictitiousSwitchesForDisconnectedTerminalsMode;
        }

        public Config createFictitiousSwitchesForDisconnectedTerminalsMode(CgmesImport.FictitiousSwitchesCreationMode createFictitiousSwitchesForDisconnectedTerminalsMode) {
            this.createFictitiousSwitchesForDisconnectedTerminalsMode = createFictitiousSwitchesForDisconnectedTerminalsMode;
            return this;
        }

        public Config setDisconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected(boolean b) {
            this.disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected = b;
            return this;
        }

        public boolean disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected() {
            return this.disconnectNetworkSideOfDanglingLinesIfBoundaryIsDisconnected;
        }

        public static enum StateProfile {
            SSH,
            SV;

        }
    }

    static class LineContainerFictitiousVoltageLevelData {
        String lineId;
        String lineName;
        String nodeId;
        VoltageLevel vl;

        LineContainerFictitiousVoltageLevelData() {
        }
    }

    public static enum Xfmr3StructuralRatioInterpretationAlternative {
        NETWORK_SIDE,
        STAR_BUS_SIDE,
        END1,
        END2,
        END3;

    }

    public static enum Xfmr3ShuntInterpretationAlternative {
        NETWORK_SIDE,
        STAR_BUS_SIDE,
        SPLIT;

    }

    public static enum Xfmr3RatioPhaseInterpretationAlternative {
        NETWORK_SIDE,
        STAR_BUS_SIDE;

    }

    public static enum Xfmr2StructuralRatioInterpretationAlternative {
        END1,
        END2,
        X;

    }

    public static enum Xfmr2ShuntInterpretationAlternative {
        END1,
        END2,
        END1_END2,
        SPLIT;

    }

    public static enum Xfmr2RatioPhaseInterpretationAlternative {
        END1,
        END2,
        END1_END2,
        X;

    }
}

