/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.iidm.network.Country;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CountryConversion {
    private static final Logger LOG = LoggerFactory.getLogger(CountryConversion.class);

    private CountryConversion() {
    }

    public static Optional<Country> fromRegionName(String gr) {
        if (gr == null) {
            return Optional.empty();
        }
        if (gr.equals("D1") || gr.equals("D2") || gr.equals("D4") || gr.equals("D7") || gr.equals("D8")) {
            return Optional.of(Country.DE);
        }
        try {
            return Optional.of(Country.valueOf((String)gr));
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("{} does not match any Country enum", (Object)gr);
            return Optional.empty();
        }
    }

    public static Optional<Country> fromSubregionName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        switch (name.trim().toUpperCase()) {
            case "NO1": 
            case "NO2": 
            case "NO3": 
            case "NO4": 
            case "NO5": {
                return Optional.of(Country.NO);
            }
            case "SE1": 
            case "SE2": 
            case "SE3": 
            case "SE4": {
                return Optional.of(Country.SE);
            }
            case "FI1": {
                return Optional.of(Country.FI);
            }
            case "DK1": 
            case "DK2": {
                return Optional.of(Country.DK);
            }
            case "EE1": {
                return Optional.of(Country.EE);
            }
            case "LV1": {
                return Optional.of(Country.LV);
            }
            case "LT1": {
                return Optional.of(Country.LT);
            }
        }
        return Optional.empty();
    }

    public static Optional<Country> fromIsoCode(String iso) {
        if (iso == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Country.valueOf((String)iso.trim().toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }
}

