/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.conversion.CgmesImportPostProcessor;
import com.powsybl.cgmes.conversion.CgmesModelExtension;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.GeneratorEntsoeCategoryAdder;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.TripleStore;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={CgmesImportPostProcessor.class})
public class EntsoeCategoryPostProcessor
implements CgmesImportPostProcessor {
    public static final String NAME = "EntsoeCategory";
    private static final Logger LOG = LoggerFactory.getLogger(EntsoeCategoryPostProcessor.class);

    public EntsoeCategoryPostProcessor() {
        this(PlatformConfig.defaultConfig());
    }

    public EntsoeCategoryPostProcessor(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void process(Network network, TripleStore tripleStore) {
        Objects.requireNonNull(network);
        LOG.info("Execute {} post processor on network {}", (Object)this.getName(), (Object)network.getId());
        for (PropertyBag sm : ((CgmesModelExtension)network.getExtension(CgmesModelExtension.class)).getCgmesModel().synchronousMachinesGenerators()) {
            String generatingUnitId = sm.getId("GeneratingUnit");
            if (generatingUnitId == null) continue;
            EntsoeCategoryPostProcessor.processGenerator(network, sm, generatingUnitId);
        }
    }

    private static void processGenerator(Network network, PropertyBag sm, String generatingUnitId) {
        String description = sm.getId("generatingUnitDescription");
        if (!StringUtils.isNumericSpace((CharSequence)description)) {
            return;
        }
        String description1 = description.trim();
        if (description1.isEmpty()) {
            return;
        }
        String generatorId = sm.getId("SynchronousMachine");
        Generator g = network.getGenerator(generatorId);
        if (g == null) {
            return;
        }
        try {
            int code = Integer.parseInt(description1);
            if (code > 0) {
                ((GeneratorEntsoeCategoryAdder)g.newExtension(GeneratorEntsoeCategoryAdder.class)).withCode(code).add();
            }
        }
        catch (Exception x) {
            LOG.error("Bad number for ENTSO-E category from description [{}], generating Unit: {}, generator: {}", new Object[]{description, generatingUnitId, generatorId});
        }
    }
}

