/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class LoadingLimitsMapping {
    protected final Map<String, LoadingLimitsAdder<?, ?>> adders = new HashMap();
    private final Context context;

    LoadingLimitsMapping(Context context) {
        this.context = Objects.requireNonNull(context);
    }

    public LoadingLimitsAdder computeIfAbsentLoadingLimitsAdder(String id, Supplier<LoadingLimitsAdder<?, ?>> supplier) {
        return this.adders.computeIfAbsent(id, s -> (LoadingLimitsAdder)supplier.get());
    }

    void addAll() {
        for (Map.Entry<String, LoadingLimitsAdder<?, ?>> entry : this.adders.entrySet()) {
            if (Double.isNaN(entry.getValue().getPermanentLimit())) {
                if (!entry.getValue().hasTemporaryLimits()) continue;
            }
            entry.getValue().fixLimits(this.context.config().getMissingPermanentLimitPercentage(), this.context::fixed).add();
        }
        this.adders.clear();
    }
}

