/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion;

import com.powsybl.cgmes.conversion.CgmesImport;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.HashMap;
import java.util.Map;

public class NodeMapping {
    private final Map<String, Integer> cgmes2iidm;
    private final Map<VoltageLevel, Integer> voltageLevelNumNodes;
    private final Context context;

    public NodeMapping(Context context) {
        this.context = context;
        this.cgmes2iidm = new HashMap<String, Integer>(100);
        this.voltageLevelNumNodes = new HashMap<VoltageLevel, Integer>(100);
    }

    public int iidmNodeForTopologicalNode(String id, int associatedNode, VoltageLevel vl) {
        String uniqueId;
        int i = 0;
        while (this.cgmes2iidm.containsKey(uniqueId = id + "#" + i++) && i < Integer.MAX_VALUE) {
        }
        int iidmNodeForTopologicalNode = this.newNode(vl);
        this.cgmes2iidm.put(uniqueId, iidmNodeForTopologicalNode);
        vl.getNodeBreakerView().newInternalConnection().setNode1(iidmNodeForTopologicalNode).setNode2(associatedNode).add();
        return iidmNodeForTopologicalNode;
    }

    public int iidmNodeForTerminal(CgmesTerminal t, boolean isSwitchEnd, VoltageLevel vl) {
        return this.iidmNodeForTerminal(t, isSwitchEnd, vl, true);
    }

    public int iidmNodeForTerminal(CgmesTerminal t, boolean isSwitchEnd, VoltageLevel vl, boolean equipmentIsConnected) {
        boolean connected;
        int iidmNodeForConductingEquipment = this.cgmes2iidm.computeIfAbsent(t.id(), id -> this.newNode(vl));
        int iidmNodeForConnectivityNode = this.cgmes2iidm.computeIfAbsent(t.connectivityNode(), id -> this.newNode(vl));
        boolean bl = connected = t.connected() && equipmentIsConnected;
        if (connected || !NodeMapping.createFictitiousSwitch(this.context.config().getCreateFictitiousSwitchesForDisconnectedTerminalsMode(), isSwitchEnd)) {
            vl.getNodeBreakerView().newInternalConnection().setNode1(iidmNodeForConductingEquipment).setNode2(iidmNodeForConnectivityNode).add();
        } else {
            String switchId = t.id() + "_SW_fict";
            if (vl.getNetwork().getSwitch(switchId) == null) {
                Switch sw = ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl.getNodeBreakerView().newSwitch().setFictitious(true)).setId(switchId)).setName(t.name())).setNode1(iidmNodeForConductingEquipment).setNode2(iidmNodeForConnectivityNode).setOpen(true).setKind(SwitchKind.BREAKER).setEnsureIdUnicity(this.context.config().isEnsureIdAliasUnicity())).add();
                sw.setProperty("CGMES.isCreatedForDisconnectedTerminal", "true");
            }
        }
        return iidmNodeForConductingEquipment;
    }

    private static boolean createFictitiousSwitch(CgmesImport.FictitiousSwitchesCreationMode mode, boolean isSwitchEnd) {
        switch (mode) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case ALWAYS_EXCEPT_SWITCHES: {
                return !isSwitchEnd;
            }
        }
        throw new IllegalStateException("Unsupported specified mode to create fictitious switches for disconnected terminals: " + mode.name());
    }

    public int iidmNodeForConnectivityNode(String id, VoltageLevel vl) {
        return this.cgmes2iidm.computeIfAbsent(id, k -> this.newNode(vl));
    }

    private int newNode(VoltageLevel vl) {
        int numNodes = this.voltageLevelNumNodes.merge(vl, 1, Integer::sum);
        return numNodes - 1;
    }
}

